#include "stdafx.h"
#include "CMediaSessionNative.h"
#include "CustomEVRPresenter.h"
#include "CustomGUID.h"

namespace FDK
{
	CMediaSessionNative::CMediaSessionNative()
	{
		try
		{
			AllInstances::tǉ( this );

			this->nQƃJE^ = 1;
			this->Status.Set( CStatus::EStatus::ĐI );

			this->pMediaSession = NULL;
			this->pSequencerSource = NULL;
			this->pMediaSession = NULL;
			this->pControl = NULL;
			this->pAttributes = NULL;

			for( int i = 0; i < 2; i++ )
			{
				this->Segments[ i ].TopologyID = 0;
				this->Segments[ i ].SegmentID = 0;
				this->Segments[ i ].pTopology = NULL;
				this->Segments[ i ].bĐ = false;
			}
			this->b[v.Set( false );
			this->n\index.Set( 0 );

			#pragma region [ MediaSession CxgʒmpCxg̍쐬 ]
			//-----------------
			tNULLȂO( L"MESessionClosed Cxg̍쐬",
				this->evMESessionClosed = ::CreateEvent( NULL, TRUE, FALSE, L"MediaSessionN[Yꂽ" ) );

			tNULLȂO( L"MESessionStarted Cxg̍쐬",
				this->evMESessionStarted = ::CreateEvent( NULL, TRUE, FALSE, L"v[^`Jn" ) );

			tNULLȂO( L"MESessionStopped Cxg̍쐬",
				this->evMESessionStopped = ::CreateEvent( NULL, TRUE, FALSE, L"Đ~" ) );
			//-----------------
			#pragma endregion

			{
				AutoLock lock( this->cst@C );
				this->stgt@C[ 0 ] = '\0';
			}
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	CMediaSessionNative::CMediaSessionNative( HWND hWnd, DWORD dwMediaSessionCxgXbhID, LPCWSTR stgt@C, bool b, bool b[v )
		: CMediaSessionNative()
	{
		this->t\z( hWnd, dwMediaSessionCxgXbhID, stgt@C, b, b[v );
	}
	CMediaSessionNative::~CMediaSessionNative()
	{
		//  GC  CMediaSession ̃t@CiCUoRŌĂяo\̂ŁAO͔ȂB

		HRESULT hr = S_OK;

		::ResetEvent( this->evMESessionStopped );
		::ResetEvent( this->evMESessionClosed );

		this->pMediaSession->Stop();							// Stopi񓯊j
		::WaitForSingleObject( this->evMESessionStopped, INFINITE );

		this->pSequencerMediaSource->Shutdown();				// V[PT[\[XVbg_E

		this->pMediaSession->Close();							// Closei񓯊j
		::WaitForSingleObject( this->evMESessionClosed, INFINITE );

		this->Status.Set( CStatus::EStatus::҂ );			// ȍ~AMediaSession CxgȂB

		this->pMediaSession->Shutdown();						// Shutdown

		SAFE_COM_RELEASE( this->Segments[ 0 ].pTopology );
		SAFE_COM_RELEASE( this->Segments[ 1 ].pTopology );
		SAFE_COM_RELEASE( this->pSequencerMediaSource );
		SAFE_COM_RELEASE( this->pSequencerSource );
		SAFE_COM_RELEASE( this->pMediaSession );
		SAFE_COM_RELEASE( this->pAttributes );	// IMFAttributes ̉
		SAFE_COM_RELEASE( this->pControl );		// IMFVideoDisplayControl ̉

		::CloseHandle( this->evMESessionClosed );
		::CloseHandle( this->evMESessionStarted );
		::CloseHandle( this->evMESessionStopped );

		AllInstances::t폜( this );
	}

	void CMediaSessionNative::t\z( HWND hWnd, DWORD dwMediaSessionCxgXbhID, LPCWSTR stgt@C, bool b, bool b[v )
	{
		HRESULT hr = S_OK;

		if( NULL != this->pMediaSession )
			throw gcnew Exception( L"MediaSession ͂łɍ\zς݂łB" );

		try
		{
			// p[^ۑB

			this->dwCxgXbhID = dwMediaSessionCxgXbhID;
			this->b[v.Set( b[v );

			#pragma region [ t@CۑB]
			//-----------------
			{
				TCHAR stgDrive[ _MAX_DRIVE ];
				TCHAR stgDir[ _MAX_DIR ];
				TCHAR stgFname[ _MAX_FNAME ];
				TCHAR stgExt[ _MAX_EXT ];

				errno_t err = _wsplitpath_s( stgt@C, stgDrive, _MAX_DRIVE, stgDir, _MAX_DIR, stgFname, _MAX_FNAME, stgExt, _MAX_EXT );
				if( err != 0 )
					throw gcnew Exception( L"t@C̉͂Ɏs܂B" );

				AutoLock l( this->cst@C );

				int n = swprintf_s( this->stgt@C, MAX_PATH, L"%s%s", stgFname, stgExt );
				if( n <= 0 )
					throw gcnew Exception( L"t@C̍č\zɎs܂B" );
			}
			//-----------------
			#pragma endregion


			// MediaSession 쐬B

			#pragma region [ MediaSession 쐬ACxg擾JnB]
			//-----------------
			tFAILEDȂO( L"MediaSession ̍쐬",
				hr = ::MFCreateMediaSession( NULL, &( this->pMediaSession ) ) );

			tFAILEDȂO( L"MediaSession ւ̃R[obNIuWFNg̓o^",
				hr = this->pMediaSession->BeginGetEvent( this, NULL ) );
			//-----------------
			#pragma endregion


			// V[PT[\[X쐬B

			#pragma region [ V[PT[\[XƂ̃fBA\[X쐬B]
			//-------------------------
			tFAILEDȂO( L"V[PT[\[X̍쐬",
				hr = ::MFCreateSequencerSource( NULL, &( this->pSequencerSource ) ) );

			tFAILEDȂO( L"V[PT[\[X̃fBA\[X̎擾",
				hr = this->pSequencerSource->QueryInterface( IID_PPV_ARGS( &( this->pSequencerMediaSource ) ) ) );
			//-------------------------
		#pragma endregion


			// g|W쐬AV[PT[\[Xɓo^B

			if( this->b[v.Get() )
			{
				#pragma region [ (A) [vꍇ ]
				//-------------------------
				this->tg|W쐬( hWnd, stgt@C, b, &( this->Segments[ 0 ].pTopology ) );

				tFAILEDȂO( L"V[PT[\[Xւ̃g|W̓o^iPZOgj",
					hr = this->pSequencerSource->AppendTopology( this->Segments[ 0 ].pTopology, 0/*LasttOȂ*/, &( this->Segments[ 0 ].SegmentID ) ) );

				tFAILEDȂO( L"g|WID̎擾iPZOgj",
					hr = this->Segments[ 0 ].pTopology->GetTopologyID( &( this->Segments[ 0 ].TopologyID ) ) );


				this->tg|W쐬( hWnd, stgt@C, b, &( this->Segments[ 1 ].pTopology ) );

				tFAILEDȂO( L"V[PT[\[Xւ̃g|W̓o^iQZOgj",
					hr = this->pSequencerSource->AppendTopology( this->Segments[ 1 ].pTopology, 0, &( this->Segments[ 1 ].SegmentID ) ) );

				tFAILEDȂO( L"g|WID̎擾iQZOgj",
					hr = this->Segments[ 1 ].pTopology->GetTopologyID( &( this->Segments[ 1 ].TopologyID ) ) );
				//-------------------------
				#pragma endregion
			}
			else
			{
				#pragma region [ (B) [vȂꍇ ]
				//-------------------------
				this->tg|W쐬( hWnd, stgt@C, b, &( this->Segments[ 0 ].pTopology ) );

				tFAILEDȂO( L"V[PT[\[Xւ̃g|W̓o^",
					hr = this->pSequencerSource->AppendTopology( this->Segments[ 0 ].pTopology, MFSequencerTopologyFlags::SequencerTopologyFlags_Last, &( this->Segments[ 0 ].SegmentID ) ) );

				tFAILEDȂO( L"g|WID̎擾",
					hr = this->Segments[ 0 ].pTopology->GetTopologyID( &( this->Segments[ 0 ].TopologyID ) ) );

				this->Segments[ 1 ].SegmentID = 0;
				this->Segments[ 1 ].TopologyID = 0;
				//-------------------------
				#pragma endregion
			}

			// ŏ̃g|W MediaSession ɓo^B

			#pragma region [ ŏ̃g|W MediaSession ɓo^B]
			//-------------------------
			IMFPresentationDescriptor *pPD = NULL;

			try
			{
				tFAILEDȂO( L"ŏ̃v[e[VLqq̎擾",
					hr = this->pSequencerMediaSource->CreatePresentationDescriptor( &pPD ) );

				this->t̃ZOgMediaSessionɓo^( pPD );
			}
			finally	
			{
				SAFE_COM_RELEASE( pPD );
			}
			//-------------------------
			#pragma endregion
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			SAFE_COM_RELEASE( this->Segments[ 0 ].pTopology );
			SAFE_COM_RELEASE( this->Segments[ 1 ].pTopology );
			SAFE_COM_RELEASE( this->pSequencerMediaSource );
			SAFE_COM_RELEASE( this->pSequencerSource );
			SAFE_COM_RELEASE( this->pMediaSession );
			throw gcnew Exception( L"MediaSession ̍\zɎs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	void CMediaSessionNative::tĐ( UINT64 nĐJnʒu100ns )
	{
		HRESULT hr = S_OK;

		try
		{
			// Zbg

			tFALSEȂO( L"MESessionStartedCxg̃Zbg",
				::ResetEvent( this->evMESessionStarted ) );


			// ĐJnwB

			PROPVARIANT prop;
			::PropVariantInit( &prop );
			prop.vt = VT_I8;
			prop.hVal.QuadPart = nĐJnʒu100ns;

			tFAILEDȂO( L"IMFMediaSession::Start() ",
				hr = this->pMediaSession->Start( NULL, &prop ) );

			this->Status.Set( CStatus::EStatus::Đ );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"ĐɎs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	void CMediaSessionNative::t~()
	{
		HRESULT hr = S_OK;

		try
		{
			tFAILEDȂO( L"IMFMediaSession::Stop() ",
				hr = this->pMediaSession->Stop() );

			this->Status.Set( CStatus::EStatus::~ );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"~Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	void CMediaSessionNative::tꎞ~()
	{
		HRESULT hr = S_OK;

		try
		{
			tFAILEDȂO( L"IMFMediaSession::Pause() ",
				hr = this->pMediaSession->Pause() );

			this->Status.Set( CStatus::EStatus::ꎞ~ );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"ꎞ~Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	void CMediaSessionNative::tĐĊJ()
	{
		HRESULT hr = S_OK;

		try
		{
			tFALSEȂO( L"MESessionStarted Cxg̃Zbg",
				::ResetEvent( this->evMESessionStarted ) );

			PROPVARIANT prop;
			::PropVariantInit( &prop );
			prop.vt = VT_EMPTY;	// ݈ʒuĐ

			tFAILEDȂO( L"IMFMediaSession::Start() ",
				hr = this->pMediaSession->Start( NULL, &prop ) );

			this->Status.Set( CStatus::EStatus::Đ );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"Đ̍ĊJɎs܂B", e );
			//-----------------
			#pragma endregion
		}
	}

	void CMediaSessionNative::tĐ܂őҋ@()
	{
		// ɃG[`FbN͂ȂB
		HRESULT hr = ::WaitForSingleObject( this->evMESessionStarted, INFINITE );

		// CxgZbgĂB
		::ResetEvent( this->evMESessionStarted );
	}

	bool CMediaSessionNative::bĐł()
	{
		CStatus::EStatus nowStatus = this->Status.Get();
		return ( CStatus::EStatus::Đ == nowStatus || CStatus::EStatus::Đ == nowStatus );
	}
	UInt64 CMediaSessionNative::ñ݂NbNԂ()
	{
		Debug::Assert( this->pMediaSession != NULL );

		HRESULT hr = S_OK;
		LONGLONG clockTime;
		MFTIME systemTime;

		try
		{
			IMFClock *pClock;
			tFAILEDȂO( L"IMFClock ̎擾",
				hr = this->pMediaSession->GetClock( &pClock ) );

			Debug::Assert( pClock != NULL );

			tFAILEDȂO( L"oߎԂ̎擾",
				hr = pClock->GetCorrelatedTime( NULL, &clockTime, &systemTime ) );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"݂̃NbN̎擾Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}

		return clockTime;
	}
	void CMediaSessionNative::txݒ肷( UINT32 ux )
	{
		Debug::Assert( this->pAttributes != NULL );

		HRESULT hr = S_OK;

		try
		{
			tFAILEDȂO( L"MediaSession̓x̐ݒ",
				hr = this->pAttributes->SetUINT32( GUIDofeNX`̓x, ux ) );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"MediaSession̓x̐ݒɎs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	void CMediaSessionNative::tZ( bool bZ )
	{
		Debug::Assert( this->pAttributes != NULL );

		HRESULT hr = S_OK;

		try
		{
			tFAILEDȂO( L"MediaSession̉Z̐ݒ",
				hr = this->pAttributes->SetUINT32( GUIDofeNX`̉Z, ( bZ ) ? 1 : 0 ) );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"MediaSession̉Z̐ݒɎs܂B", e );
			//-----------------
			#pragma endregion
		}
	}

	void CMediaSessionNative::t̃Tvv()
	{
		//Debug::Assert( this->pControl != NULL );		惋[vASSERTɂЂĂ܂B
		if( NULL == this->pControl )
			return;


		// Đ낤łȂ낤Ăяôŗv`FbNB

		if( CStatus::EStatus::Đ != this->Status.Get() )
			return;


		HRESULT hr = S_OK;

		try
		{
			tFAILEDȂO( L"̃Tv̗v",
				hr = this->pControl->SetRenderingPrefs( MFVideoRenderPrefs_RequestNextSample ) );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"̃Tv̗vɎs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	void CMediaSessionNative::tŐṼTv`悷( LPRECT prc` )
	{
		Debug::Assert( this->pControl != NULL );


		// Đ낤łȂ낤Ăяôŗv`FbNB

		if( CStatus::EStatus::Đ != this->Status.Get() )
			return;


		HRESULT hr = S_OK;

		try
		{
			tFAILEDȂO( L"`ʒu̒ʒm",
				hr = this->pControl->SetVideoPosition( NULL, prc` ) );


			tFAILEDȂO( L"Ǝ`bZ[Wɂv[^ւ̕`ʒm",
				hr = this->pControl->SetRenderingPrefs( MFVideoRenderPrefs_DisplaySample ) );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"ŐṼTv̕`Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}
	}
	void CMediaSessionNative::t摜TCY擾( SIZE *pSize )
	{
		Debug::Assert( this->pControl != NULL );


		// Đ낤łȂ낤Ăяôŗv`FbNB

		if( CStatus::EStatus::Đ != this->Status.Get() )
			return;


		HRESULT hr = S_OK;

		try
		{
			tFAILEDȂO( L"lCeBurfITCY̎擾",
				hr = this->pControl->GetNativeVideoSize( pSize, NULL ) );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"摜TCY̎擾Ɏs܂B", e );
			//-----------------
			#pragma endregion
		}
	}

	HRESULT CMediaSessionNative::tMediaSessionCxg( IMFMediaEvent* pEvent )
	{
		//  ̃\bh́A\zɎw肵XbhĂяoB

		HRESULT hr = S_OK;
		BOOL bResult = false;

		// Cxg^Cv擾B
		MediaEventType meType = MEUnknown;
		if( FAILED( hr = pEvent->GetType( &meType ) ) )
			goto failed;

		// Cxg^CvɉďB

		switch( meType )
		{
		case MESessionTopologySet:
			#pragma region [ g|WB]
			//-------------------------
			this->cst@C.Lock();
			Trace::TraceInformation( "MESessionTopologySet: g|W܂B[{0}]", gcnew String( this->stgt@C ) );
			this->cst@C.Unlock();
			break;
			//-------------------------
			#pragma endregion

		case MESessionTopologyStatus:
			#pragma region [ g|W̃Xe[^XωB]
			//-----------------
			Trace::TraceInformation( "MESessionTopologyStatus: g|W̃Xe[^Xω܂B" );
			Trace::Indent();
			{
				MF_TOPOSTATUS status = MF_TOPOSTATUS_INVALID;
				TOPOID topoID = 0;

				#pragma region [ Cxgg|WID擾B]
				//-------------------------
				IMFTopology *pTopology = NULL;
				PROPVARIANT var;
				::PropVariantInit( &var );
				if( FAILED( hr = pEvent->GetValue( &var ) ) ||
					( VT_UNKNOWN != var.vt ) ||
					( FAILED( hr = var.punkVal->QueryInterface( __uuidof( IMFTopology ), (void**) &pTopology ) ) ) )
				{
					tFAILEDȂTraceError( "MESessionTopologyStatus: g|W̎擾", hr );
					::PropVariantClear( &var );
					Trace::Unindent();
					goto failed;
				}
				if( FAILED( hr = pTopology->GetTopologyID( &topoID ) ) )
				{
					tFAILEDȂTraceError( "MESessionTopologyStatus: g|WID̎擾", hr );
					SAFE_COM_RELEASE( pTopology );
					::PropVariantClear( &var );
					Trace::Unindent();
					goto failed;
				}
				SAFE_COM_RELEASE( pTopology );
				::PropVariantClear( &var );
				//-------------------------
				#pragma endregion
				#pragma region [ Cxgg|WXe[^XR[h擾B]
				//-----------------
				UINT32 nR[h;

				if( FAILED( hr = pEvent->GetUINT32( MF_EVENT_TOPOLOGY_STATUS, &nR[h ) ) )
				{
					tFAILEDȂTraceError( "MESessionTopologyStatus: g|WXe[^XR[h̎擾", hr );
					Trace::Unindent();
					goto failed;
				}

				status = (MF_TOPOSTATUS) nR[h;
				//-----------------
				#pragma endregion

				int index = ( topoID == this->Segments[ 0 ].TopologyID ) ? 0 : 1;


				// Xe[^XR[hɂďB

				switch( status )
				{
				case MF_TOPOSTATUS_READY:
					#pragma region [ g|W̏B]
					//-----------------
					Trace::TraceInformation( "MF_TOPOSTATUS_READY[ {0} ]; g|W̏܂B", index );

					// IMFVideoDisplayControl ̎擾

					SAFE_COM_RELEASE( this->pControl );
					Debug::Assert( SUCCEEDED( hr = ::MFGetService( this->pMediaSession, MR_VIDEO_RENDER_SERVICE, IID_PPV_ARGS( &( this->pControl ) ) ) ) );		// DebugŐReleaseŎsP[X͂Ȃ낤ƑzB

					// IMFAttributes ̎擾

					SAFE_COM_RELEASE( this->pAttributes );
					Debug::Assert( SUCCEEDED( hr = ::MFGetService( this->pMediaSession, MR_VIDEO_RENDER_SERVICE, IID_PPV_ARGS( &( this->pAttributes ) ) ) ) );	// B

					break;
					//-----------------
					#pragma endregion

				case MF_TOPOSTATUS_STARTED_SOURCE:
					#pragma region [ g|W̃fBA\[X̓ǂݍ݂JnB]
					//-------------------------
					Trace::TraceInformation( "MF_TOPOSTATUS_STARTED_SOURCE[ {0} ]; MediaSessiong|W̃fBA\[Xǂݍ݂Jn܂B", index );
					this->Segments[ index ].bĐ = true;
					this->tKvȂZOg[e[Vs();
					break;
					//-------------------------
					#pragma endregion

				case MF_TOPOSTATUS_SINK_SWITCHED:
					#pragma region [ fBAVN̐ڑ̃g|Wɐ؂ւꂽB]
					//-------------------------
					Trace::TraceInformation( "MF_TOPOSTATUS_SINK_SWITCHED[ {0} ]; fBAVN̐ڑ̃g|Wɐ؂ւ܂B", index );
					break;
					//-------------------------
					#pragma endregion

				case MF_TOPOSTATUS_ENDED:
					#pragma region [ g|W̍ĐB]
					//-------------------------
					Trace::TraceInformation( "MF_TOPOSTATUS_ENDED[ {0} ]; g|W̍Đ܂BiMediaSession͂܂g|WgpĂ\Bj", index );
					this->Segments[ index ].bĐ = false;
					this->tKvȂZOg[e[Vs();
					break;
					//-------------------------
					#pragma endregion

				default:
					Trace::TraceInformation( String::Format( "Unkonwn Status: {0}", (int) status ) );
					break;
				}
			}
			Trace::Unindent();
			break;
			//-----------------
			#pragma endregion

		case MESessionStarted:
			#pragma region [ ĐJnꂽiĐJnjB]
			//-----------------
			Trace::TraceInformation( "MESessionStarted; ĐJn܂B" );
			Trace::Indent();
			{
				// Xe[^XuĐvɕύXB

				this->Status.Set( CStatus::EStatus::Đ );


				// `JnCxg𔭉΁B

				if( FALSE == ( bResult = ::SetEvent( this->evMESessionStarted ) ) )
				{
					tFALSEȂTraceError( "CMediaSessionNative::evMESessionStated ̔", bResult );
					Trace::Unindent();
					goto failed;
				}
			}
			Trace::Unindent();
			break;
			//-----------------
			#pragma endregion

		case MESessionStopped:
			#pragma region [ Đ~ꂽiĐ~jB]
			//-----------------
			Trace::TraceInformation( "MESessionStopped; Đ~܂B" );
			Trace::Indent();
			{
				// Xe[^Xu~vɕύXB

				this->Status.Set( CStatus::EStatus::~ );


				// `~tO𗧂āACxg𔭉΁B

				if( FALSE == ( bResult = ::SetEvent( this->evMESessionStopped ) ) )
				{
					tFALSEȂTraceError( "CMediaSessionNative::evMESessionStopped ̔", bResult );
					Trace::Unindent();
					goto failed;
				}
			}
			Trace::Unindent();
			break;
			//-----------------
			#pragma endregion

		case MESessionPaused:
			#pragma region [ Đꎞ~ꂽiĐꎞ~jB]
			//-----------------
			Trace::TraceInformation( "MESessionPaused; Đꎞ~܂B" );
			Trace::Indent();
			{
				// Xe[^Xuꎞ~vɕύXB

				this->Status.Set( CStatus::EStatus::ꎞ~ );
			}
			Trace::Unindent();
			break;
			//-----------------
			#pragma endregion

		case MEEndOfPresentation:
			#pragma region [ fBA\[X̃f[^sBiĐ͂܂IĂȂ\Bj]
			//-------------------------
			Trace::TraceInformation( "MEEndOfPresentation; fBA\[XI܂B" );
			Trace::Indent();
			{
			}
			Trace::Unindent();
			break;
			//-------------------------
			#pragma endregion

		case MEEndOfPresentationSegment:
			#pragma region [ ZOg̃fBA\[X̃f[^sBiĐ͂܂IĂȂ\Bj]
			//-------------------------
			Trace::TraceInformation( "MEEndOfPresentationSegment; ZOg̃fBA\[XI܂B" );
			Trace::Indent();
			{
			}
			Trace::Unindent();
			break;
			//-------------------------
			#pragma endregion

		case MESessionEnded:
			#pragma region [ ĐIB]
			//-----------------
			Trace::TraceInformation( "MESessionEnded; ĐI܂B" );
			Trace::Indent();
			{
				// Xe[^XuĐIvɕύXB

				this->Status.Set( CStatus::EStatus::ĐI );
			}
			Trace::Unindent();
			break;
			//-----------------
			#pragma endregion

		case MENewPresentation:
			#pragma region [ ̃ZOgMediaSessionɃL[CO悤wꂽB]
			//-----------------
			Trace::TraceInformation( "MENewPresentatio; ̃ZOg̍Đw܂B" );
			Trace::Indent();
			{
				IMFPresentationDescriptor *pPD = NULL;

				try
				{
					#pragma region [ pEvent v[e[VLqq pPD 擾B]
					//-------------------------
					PROPVARIANT var;
					::PropVariantInit( &var );
					if( FAILED( hr = pEvent->GetValue( &var ) ) ||
						( VT_UNKNOWN != var.vt ) ||
						( FAILED( hr = var.punkVal->QueryInterface( __uuidof( IMFPresentationDescriptor ), (void**) &pPD ) ) ) )
					{
						tFAILEDȂTraceError( "MENewPresentation: v[e[VLqq̎擾", hr );
						::PropVariantClear( &var );
						Trace::Unindent();
						goto failed;
					}
					//-------------------------
					#pragma endregion

					this->t̃ZOgMediaSessionɓo^( pPD );
				}
				finally
				{
					SAFE_COM_RELEASE( pPD );
				}
			}
			Trace::Unindent();
			break;
			//-----------------
#pragma endregion

		case MESessionNotifyPresentationTime:
			#pragma region [ VĐJnꂽB]
			//-------------------------
			Trace::TraceInformation( "MESessionNotifyPresentationTime; Vv[e[VJn܂B" );
			Trace::Indent();
			{
				UINT64 startPresentationTime;
				if( SUCCEEDED( hr = pEvent->GetUINT64( MF_EVENT_START_PRESENTATION_TIME, &startPresentationTime ) ) )
					Trace::TraceInformation( "v[e[VJn = {0}", startPresentationTime );

				UINT64 presentationTimeOffset;
				if( SUCCEEDED( hr = pEvent->GetUINT64( MF_EVENT_PRESENTATION_TIME_OFFSET, &presentationTimeOffset ) ) )
					Trace::TraceInformation( "\[Xƃv[e[V̎ItZbg = {0}", presentationTimeOffset );

				UINT64 startPresentationTimeAtOutput;
				if( SUCCEEDED( hr = pEvent->GetUINT64( MF_EVENT_START_PRESENTATION_TIME_AT_OUTPUT, &startPresentationTimeAtOutput ) ) )
					Trace::TraceInformation( "fBAVN`Jn鎞 = {0}", startPresentationTimeAtOutput );
			}
			Trace::Unindent();
			break;
			//-------------------------
			#pragma endregion

		case MESessionCapabilitiesChanged:
			#pragma region [ ZbV̔\͂ωB]
			//-------------------------
			//Trace::TraceInformation( "MESessionCapabilitiesChanged; MediaSession ̔\͒l(caps)ω܂B" );
			//Trace::Indent();
			//{
			//	UINT32 sessionCaps;
			//	if( SUCCEEDED( hr = pEvent->GetUINT32( MF_EVENT_SESSIONCAPS, &sessionCaps ) ) )
			//		Trace::TraceInformation( "VCAPS = 0x{0:X8}", sessionCaps );

			//	UINT32 sessionCapsDelta;
			//	if( SUCCEEDED( hr = pEvent->GetUINT32( MF_EVENT_SESSIONCAPS_DELTA, &sessionCapsDelta ) ) )
			//		Trace::TraceInformation( "CAPS̍ = 0x{0:X8}", sessionCapsDelta );
			//}
			//Trace::Unindent();
			break;
			//-------------------------
			#pragma endregion

		case MESessionStreamSinkFormatChanged:
			#pragma region [ fBAVÑtH[}bgύXꂽB]
			//-------------------------
			//Trace::TraceInformation( "MESessionStreamSinkFormatChanged; fBAVÑtH[}bgύX܂B" );
			//Trace::Indent();
			//{
			//	UINT64 outputNode;
			//	if( SUCCEEDED( hr = pEvent->GetUINT64( MF_EVENT_OUTPUT_NODE, &outputNode ) ) )
			//		Trace::TraceInformation( "VVÑg|WID: 0x{0:X16}", outputNode );
			//}
			//Trace::Unindent();
			break;
			//-------------------------
			#pragma endregion

		default:
			Trace::TraceInformation( String::Format( "MediaEventType: {0} ̓T|[gĂ܂B", meType ) );
			break;
		}

	failed:
		SAFE_COM_RELEASE( pEvent );
		return hr;
	}


	// IMFAsyncCallback BO𔭐Ă͂ȂȂB

	STDMETHODIMP CMediaSessionNative::GetParameters( DWORD *pdwFlags, DWORD *pdwQueue )
	{
		*pdwFlags = MFASYNC_FAST_IO_PROCESSING_CALLBACK;	// uR[obN 1ms ȓɊv錾
		*pdwQueue = MFASYNC_CALLBACK_QUEUE_STANDARD;		// u[NL[ MediaFoundation ̕Ŵ̂gpv錾
		return S_OK;
	}
	STDMETHODIMP CMediaSessionNative::Invoke( IMFAsyncResult *pAsyncResult )
	{
		//  ̃Xbh̓[NL[XbhsB

		HRESULT hr = S_OK;
		HRESULT hrCxgXe[^X = S_OK;
		IMFMediaEvent *pCxg = NULL;
		MediaEventType eCxg^Cv = MEUnknown;

		try
		{
			#pragma region [ CxgƃCxg^Cv擾B]
			//-------------------------
			tFAILEDȂA( // MesiaSession ̃fBACxg̎擾
				hr = this->pMediaSession->EndGetEvent( pAsyncResult, &pCxg ) );    // 񓯊̏IȂ̂ End.. łB̃\bh̍ŌōĂ Begin... B

			tFAILEDȂA( // fBACxg̃Cxg^Cv̎擾
				hr = pCxg->GetType( &eCxg^Cv ) );

			tFAILEDȂA( // fBACxg̃CxgXe[^X̎擾
				hr = pCxg->GetStatus( &hrCxgXe[^X ) );

			tFAILEDȂA( //CxgXe[^X̊mF; CxgXe[^XusvȂ炱ŏIB
				hrCxgXe[^X );
			//-------------------------
			#pragma endregion

			#pragma region [ MESessionClosed CxgȂICxg𔭉΂ĒʒmAłȂΎ̃Cxg҂JnB]
			//-------------------------
			if( MESessionClosed == eCxg^Cv )
			{
				// evMESessionClosedCxg𔭉΁B
				if( ::SetEvent( this->evMESessionClosed ) == FALSE )
					return E_FAIL;

				Trace::TraceInformation( "MESessionClosed; MediaSession ̃N[Y܂B" );
			}
			else
			{
				// ̃Cxg҂JnB
				tFAILEDȂA( hr = this->pMediaSession->BeginGetEvent( this, NULL ) );
			}
			//-------------------------
			#pragma endregion

			#pragma region [ Av MESessionClosed ҂ɓĂȂȂAMediaSessionCxgAv̐isXbh PostThreadMessage B]
			//-------------------------
			if( this->Status.Get() != CStatus::EStatus::҂ )
			{
				pCxg->AddRef();

				if( 0 != this->dwCxgXbhID )
				{
					STMSEVENT *pstEvent = (STMSEVENT*) malloc( sizeof( STMSEVENT ) );
					if( NULL == pstEvent )
						return E_OUTOFMEMORY;
					pstEvent->pMediaSessionNative = this;
					pstEvent->pEvent = pCxg;
					::PostThreadMessage( this->dwCxgXbhID, WM_APP_MEDIASESSION_EVENT, (WPARAM) pstEvent, NULL );	// WPARAM ́AɃ^[QbgOS̃|C^ɕϊ\B
				}
			}
			//-------------------------
			#pragma endregion
		}
		finally
		{
			SAFE_COM_RELEASE( pCxg );
		}

		return S_OK;
	}

	// IUnknown BO𔭐Ă͂ȂȂB

	STDMETHODIMP CMediaSessionNative::QueryInterface( REFIID riid, void **ppvObject )
	{
		if( riid == __uuidof( IUnknown ) )
		{
			Debug::Assert( ppvObject != NULL );
			*ppvObject = static_cast<IUnknown*>( this );
		}

		#pragma region [ ̑iG[j]
		//-----------------
		else
		{
			*ppvObject = NULL;
			return E_NOINTERFACE;
		}
		//-----------------
		#pragma endregion

		this->AddRef();

		return S_OK;
	}
	STDMETHODIMP_( ULONG ) CMediaSessionNative::AddRef()
	{
		return ::InterlockedIncrement( &this->nQƃJE^ );
	}
	STDMETHODIMP_( ULONG ) CMediaSessionNative::Release()
	{
		ULONG c = ::InterlockedDecrement( &this->nQƃJE^ );

		if( c == 0 )
			delete this;

		return c;
	}

//private:

	void CMediaSessionNative::tg|W쐬( HWND hWnd, LPCWSTR stgt@C, bool b, IMFTopology** ppTopology )
	{
		HRESULT hr = S_OK;

		*ppTopology = NULL;

		IMFTopology* pTopology = NULL;
		IMFMediaSource *pMediaSource = NULL;
		IMFPresentationDescriptor *pv[e[VLqq = NULL;

		try
		{
			// fBA\[X쐬B

			#pragma region [ fBA\[X stgt@C쐬 pMediaSource Ɏ擾B]
			//-----------------
			{
				IMFSourceResolver *pSourceResolver = NULL;
				IUnknown *pSourceObjectIUnknown = NULL;

				try
				{
					// \[X]o쐬B

					tFAILEDȂO( L"\[X]o̍쐬",
						hr = ::MFCreateSourceResolver( &pSourceResolver ) );


					// \[XIuWFNg IUnknown Ŏ擾B

					MF_OBJECT_TYPE eObjectType = MF_OBJECT_INVALID;
					tFAILEDȂO( L"\[XIuWFNg(IUnknown)̎擾",
						hr = pSourceResolver->CreateObjectFromURL( stgt@C, MF_RESOLUTION_MEDIASOURCE, NULL, &eObjectType, &pSourceObjectIUnknown ) );


					// IUnknown  IMFMediaSource 擾B

					tFAILEDȂO( L"\[XIuWFNg IUnknown  IMFMediaSource ̎擾",
						hr = pSourceObjectIUnknown->QueryInterface( IID_IMFMediaSource, (void**) &pMediaSource ) );
				}
				finally
				{
					// \[X]oB

					SAFE_COM_RELEASE( pSourceObjectIUnknown );
					SAFE_COM_RELEASE( pSourceResolver );
				}
			}
			//-----------------
			#pragma endregion
			#pragma region [ fBA\[X̃v[e[VLqqfBA\[X pv[e[VLqqɎ擾B]
			//-----------------
			tFAILEDȂO( L"fBA\[X̃v[e[VLqq̎擾",
				hr = pMediaSource->CreatePresentationDescriptor( &pv[e[VLqq ) );
			//-----------------
			#pragma endregion


			// g|W쐬B

			#pragma region [ Vg|W쐬B]
			//-----------------
			tFAILEDȂO( L"Vg|W̍쐬",
				hr = ::MFCreateTopology( &pTopology ) );
			//-----------------
	#pragma endregion
			
			DWORD dwXg[ = 0;

			#pragma region [ fBA\[X̃Xg[Av[e[VLqq dwXg[ Ɏ擾B]
			//-----------------
			tFAILEDȂO( L"fBA\[X̃Xg[̎擾",
				hr = pv[e[VLqq->GetStreamDescriptorCount( &dwXg[ ) );
			//-----------------
			#pragma endregion
			#pragma region [ ׂẴXg[g|Wɓo^B]
			//-----------------
			for( DWORD dwXg[ԍ = 0; dwXg[ԍ < dwXg[; dwXg[ԍ++ )
			{
				IMFStreamDescriptor *pXg[Lqq = NULL;
				IMFTopologyNode *pXg[̃\[Xm[h = NULL;
				IMFTopologyNode *pXg[̏o̓m[h = NULL;
				GUID guidMajorType;

				try
				{
					#pragma region [ Xg[Lqq擾B]
					//-----------------
					{
						BOOL bXg[IĂ = FALSE;

						tFAILEDȂO( L"݂̃Xg[ԍɑΉXg[Lqq̎擾",
							hr = pv[e[VLqq->GetStreamDescriptorByIndex( dwXg[ԍ, &bXg[IĂ, &pXg[Lqq ) );

						if( !bXg[IĂ )
							continue;		// IĂȂXg[ȂΖB
					}
					//-----------------
					#pragma endregion

					#pragma region [ Xg[̃\[Xm[h쐬B]
					//-----------------
					tFAILEDȂO( L"V\[Xm[hi\[XXg[m[hj̍쐬",
						hr = ::MFCreateTopologyNode( MF_TOPOLOGY_SOURCESTREAM_NODE, &pXg[̃\[Xm[h ) );

					// K{̂Rݒ肷B

					tFAILEDȂO( L"\[Xm[h̑ւ̃fBA\[X̓o^",
						hr = pXg[̃\[Xm[h->SetUnknown( MF_TOPONODE_SOURCE, pMediaSource ) );

					tFAILEDȂO( L"\[Xm[h̑ւ̃v[e[VLqq̓o^",
						hr = pXg[̃\[Xm[h->SetUnknown( MF_TOPONODE_PRESENTATION_DESCRIPTOR, pv[e[VLqq ) );

					tFAILEDȂO( L"\[Xm[h̑ւ̃Xg[Lqq̓o^",
						hr = pXg[̃\[Xm[h->SetUnknown( MF_TOPONODE_STREAM_DESCRIPTOR, pXg[Lqq ) );
					//-----------------
					#pragma endregion

					#pragma region [ Xg[̏o̓m[h쐬B]
					//-----------------
					{
						IMFActivate *pRendererActivate = NULL;

						try
						{
							#pragma region [ Vo̓m[h쐬B]
							//-----------------
							tFAILEDȂO( L"Vo̓m[h̍쐬",
								hr = MFCreateTopologyNode( MF_TOPOLOGY_OUTPUT_NODE, &pXg[̏o̓m[h ) );
							//-----------------
							#pragma endregion

							#pragma region [ Xg[̃W[^Cv擾B]
							//-----------------
							{
								IMFMediaTypeHandler *pMediaTypeHandler = NULL;

								try
								{
									tFAILEDȂO( L"Xg[̃fBA^Cvnh̎擾",
										hr = pXg[Lqq->GetMediaTypeHandler( &pMediaTypeHandler ) );

									tFAILEDȂO( L"fBA^Cvnh̃W[^CvGUID̎擾",
										hr = pMediaTypeHandler->GetMajorType( &guidMajorType ) );
								}
								finally
								{
									SAFE_COM_RELEASE( pMediaTypeHandler );
								}
							}
							//-----------------
							#pragma endregion

							#pragma region [ rfI or I[fBI_ANeBx[g쐬B]
							//-----------------
							if( MFMediaType_Audio == guidMajorType )
							{
								#pragma region [ (A) I[fBI_ANeBx[g̍쐬 ]
								//-----------------
								tFAILEDȂO( L"I[fBI_ IMFActive ̍쐬",
									hr = MFCreateAudioRendererActivate( &pRendererActivate ) );
								//-----------------
								#pragma endregion
							}
							else if( MFMediaType_Video == guidMajorType )
							{
								#pragma region [ (B) rfI_(EVR)ANeBx[g with JX^v[^ ̍쐬 ]
								//-----------------
								IUnknown *pActivate = NULL;

								try
								{
									// rfI_ANeBx[g쐬B

									tFAILEDȂO( L"rfI_ IMFActivate ̍쐬",
										hr = ::MFCreateVideoRendererActivate( hWnd, &pRendererActivate ) );


									// JX^v[^ANeBx[g𐶐B

									CustomEVRPresenter::CreateInstance( NULL, IID_IUnknown, (void**) &pActivate );


									// JX^v[^ANeBx[g_ANeBx[gɓo^B

									tFAILEDȂO( L"_ւ̃JX^v[^̐ݒ",
										hr = pRendererActivate->SetUnknown( MF_ACTIVATE_CUSTOM_VIDEO_PRESENTER_ACTIVATE, pActivate ) );
								}
								finally
								{
									SAFE_COM_RELEASE( pActivate );
								}
								//-----------------
								#pragma endregion
							}
							else
							{
								tHRESULTtO( MF_E_INVALIDTYPE, L"m̃fBA^CvłB" );
							}
							//-----------------
							#pragma endregion

							#pragma region [ rfI or I[fBI_ANeBx[go̓m[h֐ݒB]
							//-----------------
							tFAILEDȂO( L"쐬 IMFActivate ̏o̓m[hւ̐ݒ",
								hr = pXg[̏o̓m[h->SetObject( pRendererActivate ) );
							//-----------------
							#pragma endregion
						}
						finally
						{
							SAFE_COM_RELEASE( pRendererActivate );
						}
					}
					//-----------------
					#pragma endregion

					if( b || guidMajorType != MFMediaType_Audio )	// ȂȂI[fBI_͒ǉȂB
					{
						// MediaFoundation  SAR WASAPIL[hgpBb = true ŁAA̎_ŊWASAPIr[hғĂꍇ́Ag|WɃnOAbv̂ŒӁB

						#pragma region [ \[Xm[hƏo̓m[hg|WɒǉĐڑB]
						//-----------------
						tFAILEDȂO( L"g|Wւ̃\[Xm[h̒ǉ",
							hr = pTopology->AddNode( pXg[̃\[Xm[h ) );

						tFAILEDȂO( L"g|Wւ̏o̓m[h̒ǉ",
							hr = pTopology->AddNode( pXg[̏o̓m[h ) );

						DWORD dwo̓CfbNX = 0;
						DWORD dwo̓m[h̓̓CfbNX = 0;
						tFAILEDȂO( L"g|Wł̃m[hԂ̐ڑ",
							hr = pXg[̃\[Xm[h->ConnectOutput( dwo̓CfbNX, pXg[̏o̓m[h, dwo̓m[h̓̓CfbNX ) );
						//-----------------
						#pragma endregion
					}
				}
				finally
				{
					SAFE_COM_RELEASE( pXg[Lqq );
					SAFE_COM_RELEASE( pXg[̃\[Xm[h );
					SAFE_COM_RELEASE( pXg[̏o̓m[h );
				}
			}
			//-----------------
			#pragma endregion
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			SAFE_COM_RELEASE( pTopology );
			throw gcnew Exception( L"MediaSession ̍\zɎs܂B", e );
			//-----------------
			#pragma endregion
		}
		finally
		{
			SAFE_COM_RELEASE( pv[e[VLqq );
			SAFE_COM_RELEASE( pMediaSource );
		}

		*ppTopology = pTopology;	// QƃJE^pB
	}
	void CMediaSessionNative::t̃ZOgMediaSessionɓo^( IMFPresentationDescriptor *pPD )
	{
		HRESULT hr = S_OK;

		IMFMediaSourceTopologyProvider *pTopoProvider = NULL;
		IMFTopology *pTopology = NULL;

		try
		{
			tFAILEDȂO( L"g|W[voC_̎擾",
				hr = this->pSequencerSource->QueryInterface( IID_PPV_ARGS( &pTopoProvider ) ) );

			tFAILEDȂO( L"v[e[VLqqɑΉg|W̎擾",
				hr = pTopoProvider->GetMediaSourceTopology( pPD, &pTopology ) );

			tFAILEDȂO( L"MediaSessionւ̃g|W̐ݒ",
				hr = this->pMediaSession->SetTopology( NULL, pTopology ) );
		}
		finally
		{
			SAFE_COM_RELEASE( pTopology );
			SAFE_COM_RELEASE( pTopoProvider );
		}
	}
	void CMediaSessionNative::tKvȂZOg[e[Vs()
	{
		// MF_TOPOSTATUS_STARTED_SOURCE, MF_TOPOSTATUS_ENDED ĂяoB

		if( false == this->b[v.Get() )
			return;

		HRESULT hr = S_OK;

		int n\Index = this->n\index.Get();
		bool bĐ0 = this->Segments[ 0 ].bĐ;
		bool bĐ1 = this->Segments[ 1 ].bĐ;

		if( 0 == n\Index )
		{
			if( ( false == bĐ0 ) && ( true == bĐ1 ) )		// 0 ̍ĐIA1 ̍ĐJnꂽB
			{
				if( SUCCEEDED( hr ) )
					hr = this->pSequencerSource->DeleteTopology( this->Segments[ 0 ].SegmentID );												// 0 ̃ZOg폜A

				if( SUCCEEDED( hr ) )
					hr = this->pSequencerSource->AppendTopology( this->Segments[ 0 ].pTopology, 0, &( this->Segments[ 0 ].SegmentID ) );		// ĂуV[PT[\[X̖ɒǉB

				this->n\index.Set( 1 );

				Trace::TraceInformation( "ZOg 0 폜AVg|WV[PT[\[X̖ɒǉ܂B" );
			}
		}
		else
		{
			if( ( true == bĐ0 ) && ( false == bĐ1 ) )		// 1 ̍ĐIA0 ̍ĐJnꂽB
			{
				if( SUCCEEDED( hr ) )
					hr = this->pSequencerSource->DeleteTopology( this->Segments[ 1 ].SegmentID );												// 1 ̃ZOg폜A

				if( SUCCEEDED( hr ) )
					hr = this->pSequencerSource->AppendTopology( this->Segments[ 1 ].pTopology, 0, &( this->Segments[ 1 ].SegmentID ) );		// ĂуV[PT[\[X̖ɒǉB

				this->n\index.Set( 0 );

				Trace::TraceInformation( "ZOg 1 폜AVg|WV[PT[\[X̖ɒǉ܂B" );
			}
		}
	}
	void CMediaSessionNative::tEVRփfoCXύXʒm𑗂()
	{
		Debug::Assert( this->pControl != NULL );

		HRESULT hr = S_OK;

		try
		{
			tFAILEDȂO( L"Ǝ`bZ[Wł̃v[^ւ̒ʒm",
				hr = pControl->SetRenderingPrefs( MFVideoRenderPrefs_DisplayChange ) );
		}
		catch( Exception^ e )
		{
			#pragma region [ s ]
			//-----------------
			throw gcnew Exception( L"EVRւ̃foCXύXʒmɎs܂B", e );
			//-----------------
			#pragma endregion
		}
	}

//public:

	// SCX^X̊ǗB

	bool CMediaSessionNative::AllInstances::bς = false;
	CritSec CMediaSessionNative::AllInstances::csInstances;
	CMediaSessionNative* CMediaSessionNative::AllInstances::Instances[ MAX_MEDIASESSION_INSTANCES ];

	void CMediaSessionNative::AllInstances::tǉ( CMediaSessionNative *pInstance )
	{
		AutoLock lock( csInstances );

		#pragma region [ ߂Ă̒ǉȂ珉B]
		//-------------------------
		if( false == bς )
		{
			for( int i = 0; i < MAX_MEDIASESSION_INSTANCES; i++ )
				Instances[ i ] = NULL;

			bς = true;
		}
		//-------------------------
		#pragma endregion


		for( int i = 0; i < MAX_MEDIASESSION_INSTANCES; i++ )
		{
			if( NULL == Instances[ i ] )
			{
				Instances[ i ] = pInstance;
				break;
			}
		}
	}
	void CMediaSessionNative::AllInstances::t폜( CMediaSessionNative *pInstance )
	{
		AutoLock lock( csInstances );

		for( int i = 0; i < MAX_MEDIASESSION_INSTANCES; i++ )
		{
			if( Instances[ i ] == pInstance )
			{
				Instances[ i ] = NULL;
				break;
			}
		}
	}
	
	void CMediaSessionNative::AllInstances::tEVRփfoCXύXʒm𑗂()
	{
		if( false == bς )
			return;

		AutoLock lock( csInstances );

		for( int i = 0; i < MAX_MEDIASESSION_INSTANCES; i++ )
		{
			if( NULL != Instances[ i ] )
			{
				Instances[ i ]->tEVRփfoCXύXʒm𑗂();
				break;
			}
		}
	}
	void CMediaSessionNative::AllInstances::t̃Tvv()
	{
		if( false == bς )
			return;

		AutoLock lock( csInstances );

		for( int i = 0; i < MAX_MEDIASESSION_INSTANCES; i++ )
		{
			if( NULL != Instances[ i ] )
			{
				Instances[ i ]->t̃Tvv();
				break;
			}
		}
	}
	void CMediaSessionNative::AllInstances::t~()
	{
		if( false == bς )
			return;

		AutoLock lock( csInstances );

		for( int i = 0; i < MAX_MEDIASESSION_INSTANCES; i++ )
		{
			if( NULL != Instances[ i ] )
			{
				Instances[ i ]->t~();
				break;
			}
		}
	}
}