#pragma once

#include "enumD3DFormat.h"

namespace FDK
{
	[StructLayout( LayoutKind::Sequential )]
	public value class DisplayMode : IEquatable<DisplayMode>
	{
	public:
		property int Width;
		property int Height;
		property int RefreshRate;
		property D3DFormat Format;
		property float AspectRatio
		{
			float get();
		}
		
		static bool operator == ( DisplayMode left, DisplayMode right );
		static bool operator != ( DisplayMode left, DisplayMode right );
		static bool Equals( DisplayMode% value1, DisplayMode% value2 );

		virtual int GetHashCode() override;
		virtual bool Equals( Object^ obj ) override;
		virtual bool Equals( DisplayMode value );
	};
}