//using System;
//using System.Collections;
//using System.Collections.Generic;
//using System.Text;
//using System.Threading;
//using System.Net;

package slothLib.web.webLoader;

import java.io.IOException;
import java.util.concurrent.Callable;

    /**
     * MultiWebGetを管理するクラス
     */
    public class WebGetManager implements Callable<WebGetResult>
    {
        private String url;
        private String outFile;
        private String[] tagertContentType;
        private String[] excludeContentType;
        private String proxy;
        private String userAgent;

        /**
         * 終了イベント
         */
        //public ManualResetEvent finishEvent;

        /**
         * コンストラクタ
         * @param urls 取得対象のURL
         * @param maxThreadCount 最大スレッド数
         * @param outFiles ファイルの保存先
         * @param targetContentType 取得対象のContentType
         * @param excludeContentType 除外するContentType
         * @param finishEvent finishEvent
         * @param proxy HTTP通信時に用いるproxy
         * @param userAgent HTTP通信時に用いるUserAgent
         */
        public WebGetManager(String url, String outFiles, String[] targetContentType, String[] excludeContentType, String proxy, String userAgent)
        {
            this.url = url;
            this.outFile = outFiles;
            this.tagertContentType = targetContentType;
            this.excludeContentType = excludeContentType;

            this.proxy = proxy;
            this.userAgent = userAgent;
        }

        

		public WebGetResult call() throws Exception {
			WebGet wg = new WebGet();
			wg.setProxy(this.proxy);
			wg.setUserAgent(userAgent);
			WebGetResult res = wg.doFetch(url, outFile, this.tagertContentType, this.excludeContentType);
			return res;
		}
        
        
        
//        /// <summary>
//        /// WebGetに投げちゃう
//        /// </summary>
//        public void WorkerThread()
//        {
//            // 今回扱うURLのインデックス
//            int iUrl = 0;
//
//            while (true)
//            {
//                try
//                {
//                    // 今回扱うURLのインデックスを取得する
//                    iUrl = this.getNextUrlIndex();
//                    // やるべき仕事が無くなったらスレッド終了
//                    if (iUrl < 0)
//                    {
//                        break;
//                    }
//                    // URL・OutFileを取得
//                    String workUrl = this.urlList[iUrl];
//                    String workOutFile = this.outFiles[iUrl];
//
//      WebGet wg = new WebGet();
//      wg.setProxy(this.proxy);
//      wg.setUserAgent(userAgent);
//                    WebGetResult res = wg.doFetch(workUrl, workOutFile, this.tagertContentType, this.excludeContentType);
//
//                    // 結果を追加。
//                    synchronized (this.resultElements)
//                    {
//                        //this._resultElements.Add(re);
//                        //こうなってしまうと、ロックは必要ないと思うけどね。
//                        this.resultElements[iUrl] = res;
//                    }
//                }
//                catch (IOException e) 
//                {
//                	// TODO: 
//                	//throw;
//                }
//                finally
//                {
//                    // ちゃんと働いた場合のみ処理。
//                    if (iUrl >= 0)
//                    {
//                        synchronized (this)
//                        {
//                            // 一つ処理が終了した。
//
//                            this.finishNum++;
//                        }
//                    }
//
//                    // 最後のURLを処理した子は後始末をする。
//                    //if ( iUrl == this._urls.Length - 1)
//                    if (this.finishNum == this.urlList.length)
//                    {
//                        this.finishEvent.Set();
//                        // 実際にスレッドが終了するのは、次の回に-1を持ってきてから。
//                    }
//                }
//            }
//        }
//
//
//        /// <summary>
//        /// 次の仕事を引き渡す役割。
//        /// </summary>
//        private int getNextUrlIndex()
//        {
//            // ロック！！
//            synchronized (this)
//            {
//                // 次はありません。
//                if (this.cur >= this.urlList.length - 1)
//                {
//                    return -1;
//                }
//                else
//                {
//                    this.cur++;
//                    return this.cur;
//                }
//            }
//        }

    }

