package slothLib.web.webLoader;

import java.io.Serializable;
import java.net.HttpCookie;
import java.net.URI;
import java.util.Date;
import java.util.List;


/**
 * HTTPヘッダ情報を保存する
 */


public class HttpHeader implements Serializable
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String characterSet;
	private String contentEncoding;
	private long contentLength;
	private String contentType;
	private List<HttpCookie> cookies;
	private Date lastModified;
	private String method;
	private String protocolVersion;
	private URI responseUri;
	private String server;
	private int statusCode;
	private String statusDescription;

	public HttpHeader(){
	}

	
	/**
	 * コンストラクタ
	 * @param characterSet 
	 * @param contentEncoding 
	 * @param contentLength 
	 * @param contentType 
	 * @param cookies 
	 * @param lastModified 
	 * @param method 
	 * @param protocolVersion 
	 * @param responseUri 
	 * @param server 
	 * @param statusCode 
	 * @param statusDescription 
	 */
	public HttpHeader(
		String characterSet,
		String contentEncoding,
		long contentLength,
		String contentType,
		List<HttpCookie> cookies,
		Date lastModified,
		String method,
		String protocolVersion,
		URI responseUri,
		String server,
		int statusCode,
		String statusDescription)
	{
		this.characterSet = characterSet;
		this.contentEncoding = contentEncoding;
		this.contentLength = contentLength;
		this.contentType = contentType;
		this.cookies = cookies;
		this.lastModified = lastModified;
		this.method = method;
		this.protocolVersion = protocolVersion;
		this.responseUri = responseUri;
		this.server = server;
		this.statusCode = statusCode;
		this.statusDescription = statusDescription;
	}



	/**
	 * CharacterSet
	 */
	public String getCharacterSet()
	{
		return this.characterSet; 
	}
	/**
	 * ContentEncoding
	 */
	public String getContentEncoding()
	{
		return this.contentEncoding; 
	}
	/**
	 * ContentLength
	 */
	public long getContentLength()
	{
		return this.contentLength; 
	}
	/**
	 * ContentType
	 */
	public String getContentType()
	{
		return this.contentType; 
	}
	/**
	 * Cookies
	 */
	public List<HttpCookie> getCookies()
	{
		return this.cookies; 
	}
	/**
	 * LastModified
	 */
	public Date getLastModified()
	{
		return this.lastModified; 
	}
	/**
	 * Method
	 */
	public String getMethod()
	{
		return this.method; 
	}
	/**
	 * ProtocolVersion
	 */
	public String getProtocolVersion()
	{
		return this.protocolVersion; 
	}
	/**
	 * ResponseUri
	 */
	public URI getResponseUri()
	{
		return this.responseUri;
	}
	/**
	 * Server
	 */
	public String getServer()
	{
		return this.server;
	}
	/**
	 * StatusCode
	 */
	public int getStatusCode()
	{
		return this.statusCode;
	}
	/**
	 * StatusDescription
	 */
	public String getStatusDescription()
	{
		return this.statusDescription;
	}

	/**
	 * HttpHeaderの内容を表示する
	 * @return 
	 */
	public String toString()
	{

		StringBuffer sb = new StringBuffer();
		sb.append("characterSet：" + this.characterSet +"\n");
		sb.append("contentEncoding：" + this.contentEncoding +"\n");
		sb.append("contentLength：" + this.contentLength +"\n");
		sb.append("contentType：" + this.contentType +"\n");
		sb.append("cookies：" + this.cookies.toString() +"\n");
		sb.append("lastModified：" + this.lastModified +"\n");
		sb.append("method：" + this.method +"\n");
		sb.append("responseUri：" + this.responseUri +"\n");
		sb.append("server：" + this.server +"\n");
		sb.append("statusCode：" + this.statusCode +"\n");
		sb.append("statusDescription：" + this.statusDescription +"\n");

		return sb.toString();
	}
//
//	//#region ISerializable メンバ
//
//	/// <summary>
//	/// シリアライズ化するときに呼び出される関数
//	/// </summary>
//	/// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//	/// <param name="context">シリアル化ストリームの転送元と転送先</param>
//	void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//	{
//		info.AddValue("characterSet", this.characterSet);
//		info.AddValue("contentEncoding", this.contentEncoding);
//		info.AddValue("contentLength", this.contentLength);
//		info.AddValue("contentType", this.contentType);
//		info.AddValue("cookies", this.cookies);
//		info.AddValue("lastModified", this.lastModified);
//		info.AddValue("method", this.method);
//		info.AddValue("protocolVersion", this.protocolVersion);
//		info.AddValue("responseUri", this.responseUri);
//		info.AddValue("server", this.server);
//		info.AddValue("statusCode", this.statusCode);
//		info.AddValue("statusDescription", this.statusDescription);
//	}
//
//	/// <summary>
//	/// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//	/// </summary>
//	/// <param name="info">シリアル化に必要なすべてのデータ</param>
//	/// <param name="context">シリアル化ストリームの転送元と転送先</param>
//	public HttpHeader(SerializationInfo info, StreamingContext context)
//	{
//		this.characterSet = info.GetString("characterSet");
//		this.contentEncoding = info.GetString("contentEncoding");
//		this.contentLength = info.GetInt64("contentLength");
//		this.contentType = info.GetString("contentType");
//		this.cookies = (CookieCollection)info.GetValue("cookies", typeof(CookieCollection));
//		this.lastModified = info.GetDateTime("lastModified");
//		this.method = info.GetString("method");
//		this.protocolVersion = (Version)info.GetValue("protocolVersion", typeof(Version));
//		this.responseUri = (Uri)info.GetValue("responseUri", typeof(Uri));
//		this.server = info.GetString("server");
//		this.statusCode = (HttpStatusCode)info.GetValue("statusCode", typeof(HttpStatusCode));
//		this.statusDescription = info.GetString("statusDescription");
//	}



}

