package slothLib.web.search;

/**
 * キャッシュされた検索結果
 */

 public class CachedSearchResult implements ISearchResult
 {

	 /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private ISearchResult searchResult;

	 /**
	  * コンストラクタ
	  * @param searchResult 
	  */
	 public CachedSearchResult(ISearchResult searchResult)
	 {
		 this.searchResult = searchResult;
	 }
	 
	 //public ISearchResultElement this[int index]
	 //{
	 //    get { return this.searchResult[index]; }
	 //}
	 
	 
	 // IEnumerable<ISearchResultElement> メンバ
	 
	 //public IEnumerator<ISearchResultElement> GetEnumerator()
	 //{
	 //    return this.searchResult.GetEnumerator();
	 //}
	 

	 
	 // IEnumerable メンバ
	 
	 //System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
	 //{
	 //    return this.searchResult.GetEnumerator();
	 //}
	 

	 
	 
	 /**
	  * シリアライズ化するときに呼び出される関数
	  * @param info 逆シリアル化に必要なすべてのデータ
	  * @param context シリアル化ストリームの転送元と転送先
	  *void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
	  *{
		  *info.AddValue("searchResult", this.searchResult);
	  *}
	  */
	 
	 /**
	  * シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
	  * @param info シリアル化に必要なすべてのデータ
	  * @param context シリアル化ストリームの転送元と転送先
	  *protected CachedSearchResult(SerializationInfo info, StreamingContext context)
	  *{
	 *	 this.searchResult = (ISearchResult)info.GetValue("searchResult", typeof(ISearchResult));
	  *}
	  */
	 

	 /**
	  *  検索結果要素の配列
	  */
	 public ISearchResultElement [] getResultElements()
	 {
		 return this.searchResult.getResultElements();
	 }
	 
	 /**
	  * 検索に使われたクエリ
	  */
	 public String getQuery()
	 {
		 return this.searchResult.getQuery();
	 }
	 
	 /**
	  * 総検索数
	  */
	 public long getTotalNumber()
	 {
		 return this.searchResult.getTotalNumber(); 
	 }
	 
	 //ISearchResultElement ISearchResult.this[int index]
	 //{
	 //    get { return this.searchResult[index]; }
	 //}
	 
	 //int ISearchResult.Count
	 //{
	 //    get { return this.searchResult.Count; }
	 //}
	 
	 
	 // IEnumerable<ISearchResultElement> メンバ
	 
	 //IEnumerator<ISearchResultElement> IEnumerable<ISearchResultElement>.GetEnumerator()
	 //{
	 //    return this.searchResult.GetEnumerator();
	 //}
	 

}
