package slothLib.web.search;

/**
 * Yahoo Web 検索が返す検索結果全体。
 * <remarks>
 * 

 * <newpara>[2007-05-03][ohshima]作成</newpara>
 * </remarks>
 */

public class YahooJpWebSearchResult implements IWebSearchResult
{

//		#region privateフィールド

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private YahooJpWebElement[] resultElements;
	private String query;
	
	private long totalResultsAvailable;
	private int totalResultsReturned;
	private int firstResultPosition;
	//private List<ISearchResultElement> elementList;
	
//	#endregion
	
//	#region コンストラクタ
	
	/**
	 * コンストラクタ
	 * @param query 検索クエリ
	 * @param totalResultsAvailable データ内のマッチしたクエリー数です。
	 * @param totalResultsReturned 返却され、かつマッチしたクエリーの数です。もし有効な結果の合計が少ない場合、要求した結果の数より少ない場合があります。
	 * @param firstResultPosition 全検索結果の最初のポジションです。
	 * @param resultElements 検索結果要素
	 */
	public YahooJpWebSearchResult(String query, long totalResultsAvailable, int totalResultsReturned, int firstResultPosition, YahooJpWebElement[] resultElements)
	{
		this.query = query;
		this.totalResultsAvailable = totalResultsAvailable;
		this.totalResultsReturned = totalResultsReturned;
		this.firstResultPosition = firstResultPosition;
		//this.elementList = new List<ISearchResultElement>(resultElements);
		this.resultElements = resultElements;
	}
	
	///// <summary>
	///// コンストラクタ
	///// </summary>
	///// <param name="totalResultsAvailable">データ内のマッチしたクエリー数です。</param>
	///// <param name="totalResultsReturned">返却され、かつマッチしたクエリーの数です。もし有効な結果の合計が少ない場合、要求した結果の数より少ない場合があります。</param>
	///// <param name="firstResultPosition">全検索結果の最初のポジションです。</param>
	///// <param name="resultElements"></param>
	//public YahooJpWebSearchResult(string query, long totalResultsAvailable, int totalResultsReturned, int firstResultPosition, ISearchResultElement[] resultElements)
	//{
	//    this.query = query;
	//    this.totalResultsAvailable = totalResultsAvailable;
	//    this.totalResultsReturned = totalResultsReturned;
	//    this.firstResultPosition = firstResultPosition;
	//    this.elementList = new List<ISearchResultElement>(resultElements);
	//}

	
	// プロパティ
	
	/**
	 * 検索結果要素の配列
	 */
	public YahooJpWebElement[] getResultElements()
	{
		return this.resultElements; 
	}
	
	/**
	 * 検索に使われたクエリ
	 */
	public String getQuery()
	{
		return this.query;
	}
	
	/**
	 * 検索総件数
	 */
	public long getTotalResultsAvailable()
	{
		return this.totalResultsAvailable;
	}
	
	/**
	 * この検索結果に含まれる検索結果数
	 */
	public int getTotalResultsReturned()
	{
		return this.totalResultsReturned;
	}
	
	/**
	 * 全検索結果の最初のポジション
	 */
	public int getFirstResultPosition()
	{
		return this.firstResultPosition;

	}
	
	//public int Count
	//{
        //    get
        //    {
        //        return this.elementList.Count;
        //    }
        //}


//		#endregion

//		#region ISerializable メンバ

        /**
         * シリアライズ化するときに呼び出される関数
         * @param info 逆シリアル化に必要なすべてのデータ
         * @param context シリアル化ストリームの転送元と転送先
         */
//		void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//		{
//            info.AddValue("query", this.query);
//			info.AddValue("totalResultsAvailable", this.totalResultsAvailable);
//			info.AddValue("totalResultsReturned", this.totalResultsReturned);
//			info.AddValue("firstResultPosition", this.firstResultPosition);
//            //info.AddValue("elementList", this.elementList);
//            info.AddValue("resultElements", this.resultElements);
//        }

		/**
		 * シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
         * @param info シリアル化に必要なすべてのデータ
         * @param context シリアル化ストリームの転送元と転送先
		 */
//		protected YahooJpWebSearchResult(SerializationInfo info, StreamingContext context)
//		{
//            this.query = info.GetString("query");
//			this.totalResultsAvailable = info.GetInt64("totalResultsAvailable");
//			this.totalResultsReturned = info.GetInt32("totalResultsReturned");
//			this.firstResultPosition = info.GetInt32("firstResultPosition");
//            //this.elementList = (List<ISearchResultElement>)info.GetValue("elementList", typeof(List<ISearchResultElement>));
//            this.resultElements = (YahooJpWebElement[])info.GetValue("resultElements", typeof(YahooJpWebElement[]));
//        }



        // IWebSearchResult メンバ

        /**
         * 検索結果要素の配列
         */
//        IWebElement[] IWebSearchResult.ResultElements
        ///{
          //  get { return this.ResultElements; }
        //}

        //IWebElement IWebSearchResult.this[int index]
        //{
        //    get
        //    {
        //        return (IWebElement)this.elementList[index];
        //    }
        //}



        // ISearchResult メンバ

        /**
         * 検索結果要素の配列
         */
        //ISearchResultElement[] ISearchResult.ResultElements
//        {
            //get { return this.ResultElements; }
//        }

        /**
         * 検索クエリ
         */
        //public String getQuery()
//        {
        	//return this.query;
//        }

        /**
         * データ内のマッチしたクエリー数
         */
        public long getTotalNumber()
		{
        	return this.totalResultsAvailable;
        }

        //ISearchResultElement ISearchResult.this[int index]
        //{
        //    get
        //    {
        //        return this.elementList[index];
        //    }
        //}

        //int ISearchResult.Count
        //{
        //    get
        //    {
        //        return this.Count;
        //    }
        //}

//        #endregion
    
}
