package slothLib.web.search;

import java.util.Date;

/**
 * Yahoo! Web検索結果の要素を格納する
 *[Serializable]
 */
public class YahooJpWebElement implements IWebElement, IRankedElement
{
		
//		#region privateフィールド

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	int rank;
	
	String title;
	String summary;
	String url;
	String clickUrl;
	String mimeType;
	String modificationDate;
	String cacheUrl;
	String cacheSize;
	
//	#endregion
	
	
//	#region コンストラクタ
	
	/**
	 * コンストラクタ
	 * @param rank 検索エンジンにつけられたランキング
	 * @param title ページのタイトル
	 * @param summary ページに関連するテキストサマリー
	 * @param url ページのURL
	 * @param clickUrl ページのリンクURL
	 * @param mimeType ページのMIMEタイプ
	 * @param modificationDate ページが最後に修正された日付
	 * @param cacheUrl キャシュ結果のURL
	 * @param cacheSize キャシュ結果サイズ
	 */
	public YahooJpWebElement(int rank, String title, String summary, String url, String clickUrl,
			String mimeType, String modificationDate, String cacheUrl, String cacheSize)
	{
		this.rank = rank;
		this.title = title;
		this.summary = summary;
		this.url = url;
		this.clickUrl = clickUrl;
		this.mimeType = mimeType;
		this.modificationDate = modificationDate;
		this.cacheUrl = cacheUrl;
		this.cacheSize = cacheSize;
	}
	
//	#endregion
	
	
//	#region プロパティ
	
	/**
	 * ページのタイトル
	 */
	public String getTitle()
	{
		return this.title;
	}
	
	/**
	 * ページの要約
	 */
	public String getSummary()
	{
		return this.summary;
	}
	
	/**
	 * ページのURL
	 */
	public String getUrl()
	{
		return this.url;
	}
	
	/**
	 * ページのリンクURL
	 */
	public String getClickUrl()
	{
		return this.clickUrl;
	}
	
	/**
	 * ページのMimeタイプ
	 */
	public String getMimeType()
	{
		return this.mimeType;
	}
	
	/**
	 * ページが最後に修正された日付
	 */
	public Date getModificationDate()
	{
		
		if (this.modificationDate != null && this.modificationDate.length() != 0)
		{
			return new Date();
		}
		else
		{
			try
			{
			//UNIXタイムスタンプをDateTime型に変換
				return new Date((long)(Double.parseDouble(this.modificationDate)) / 1000);
			}
			catch (NumberFormatException e)
			{
			}
		}
		return new Date();
		
	}

	/**
	 * キャッシュページのURL
	 */
	public String getCacheUrl()
	{
		return this.cacheUrl;
	}
	
//	/ <summary>
	/// キャッシュページのサイズ
	/// </summary>
	public int getCacheSize()
	{
		if (this.cacheSize != null && this.cacheSize.length() != 0)
		{
			try
			{
				return Integer.parseInt(this.cacheSize);
			}
			catch (NumberFormatException e)
			{
			}
			return 0;
		}
		else
		{
			return 0;
		}
	}
	

//	#endregion



    /**
	 * ページのURL
     */
    public String getURL()
	{
		return this.getUrl();
	}

	/**
	 * ページの要約
	 */
    public String getDescription()
	{
		return this.getSummary();
	}


	/**
	 * ToStringのオーバーライド
	 * @return Flickr検索結果要素の内容
	 */
	public String toString()
	{
		return "Title: " + title + "\r\n"
		+ "URL: " + url + "\r\n"
		+ "Summary: " + summary;
	}


//		#region IRankedElement メンバ

	/**
	 * 検索エンジンにつけられたランキング
	 */
	public int getRank()
	{
		return this.rank;
		
	}

	//	#endregion


    //	#region ISerializable メンバ

	/**
	 * シリアライズ化するときに呼び出される関数
	 * @param info 逆シリアル化に必要なすべてのデータ
	 * @param context シリアル化ストリームの転送元と転送先
	 */
//	void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//	{
//		info.AddValue("rank", this.rank);
//		info.AddValue("title", this.title);
//		nfo.AddValue("summary", this.summary);
//		info.AddValue("url", this.url);
//		info.AddValue("clickUrl", this.clickUrl);
//		info.AddValue("mimeType", this.mimeType);
//		info.AddValue("modificationDate", this.modificationDate);
//		info.AddValue("cacheUrl", this.clickUrl);
//		info.AddValue("cacheSize", this.cacheSize);
//	}
	
	/**
	 * シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
	 * @param info シリアル化に必要なすべてのデータ
	 * @param context シリアル化ストリームの転送元と転送先
	 */
//	protected YahooJpWebElement(SerializationInfo info, StreamingContext context)
//	{
//		this.rank = info.GetInt32("rank");
//		this.title = info.GetString("title");
//		this.summary = info.GetString("summary");
//		this.url = info.GetString("url");
//		this.clickUrl = info.GetString("clickUrl");
//		this.mimeType = info.GetString("mimeType");
//		this.modificationDate = info.GetString("modificationDate");
//		this.cacheUrl = info.GetString("cacheUrl");
//		this.cacheSize = info.GetString("cacheSize");
//		//this.ht = (Hashtable) info.GetValue("ht", typeof(Hashtable));
//	}
	
	
//	#endregion
}

