package slothLib.web.search;

/**
 * Yahoo! 動画検索の検索結果を格納するクラス
 */
//[Serializable]
 public class YahooJpVideoSearchResult implements IVideoSearchResult
 {
	
	// privateフィールド
	
	private YahooJpVideoElement[] resultElements;
	private String query;
	
	private long totalResultsAvailable;
	private int totalResultsReturned;
	private int firstResultPosition;
	//private List<ISearchResultElement> elementList;
	
	

	
	// コンストラクタ
	
	/**
	 * コンストラクタ
	 * @param query 検索クエリ
	 * @param totalResultsAvailable データ内のマッチしたクエリ数です。
	 * @param totalResultsReturned 返却され、かつマッチしたクエリの数です。もし有効な結果の合計が少ない場合、要求した結果の数より少ない場合があります。
	 * @param firstResultPosition 全検索結果の最初のポジションです。
	 * @param resultElements 
	 */
	public YahooJpVideoSearchResult(String query, long totalResultsAvailable, int totalResultsReturned, int firstResultPosition, YahooJpVideoElement[] resultElements)
	{
		this.query = query;
		
		this.totalResultsAvailable = totalResultsAvailable;
		this.totalResultsReturned = totalResultsReturned;
		this.firstResultPosition = firstResultPosition;
		//this.elementList = new List<ISearchResultElement>(resultElements);
		this.resultElements = resultElements;
	}
	
	///// <summary>
	///// コンストラクタ
	///// </summary>
	///// <param name="totalResultsAvailable">データ内のマッチしたクエリー数です。</param>
	///// <param name="totalResultsReturned">返却され、かつマッチしたクエリーの数です。もし有効な結果の合計が少ない場合、要求した結果の数より少ない場合があります。</param>
	///// <param name="firstResultPosition">全検索結果の最初のポジションです。</param>
	///// <param name="resultElements"></param>
	//public YahooJpVideoSearchResult(String query, long totalResultsAvailable, int totalResultsReturned, int firstResultPosition, ISearchResultElement[] resultElements)
	//{
	//    this.query = query;
	
	//    this.totalResultsAvailable = totalResultsAvailable;
	//    this.totalResultsReturned = totalResultsReturned;
	//    this.firstResultPosition = firstResultPosition;
	//    this.elementList = new List<ISearchResultElement>(resultElements);
	//}
	

	
	// プロパティ
	
	/**
	 * 検索結果要素の配列
	 */
	public YahooJpVideoElement[] getResultElements()
	{
		return this.resultElements;
	}
	
		/**
		 * 検索に使われたクエリ
		 */
	public String getQuery()
	{
		return this.query;
	}

	/**
	 * 検索総件数
	 */
	public long getTotalResultsAvailable()
	{
		return this.totalResultsAvailable;
	}

	/**
	 * この検索結果に含まれる検索結果数
	 */
	public int getTotalResultsReturned()
	{
		return this.totalResultsReturned;
	}
 

	/**
	 * 全検索結果の最初のポジション
	 */
	public int getFirstResultPosition()
	{
		return this.firstResultPosition;
	}

	//public int Count
	//{
	//    get
	//    {
	//        return this.elementList.Count;
	//    }
	//}
	

	
	// ISerializable メンバ
	
	/**
	 * シリアライズ化するときに呼び出される関数
	 * @param info 逆シリアル化に必要なすべてのデータ
	 * @param context シリアル化ストリームの転送元と転送先
	 */
//	void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
//	{
//		info.AddValue("totalResultsAvailable", this.totalResultsAvailable);
//		info.AddValue("totalResultsReturned", this.totalResultsReturned);
//		info.AddValue("firstResultPosition", this.firstResultPosition);
//		//info.AddValue("elementList",this.elementList);
//		info.AddValue("resultElements", this.resultElements);
//	}
//	
//	/// <summary>
//	/// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//	/// </summary>
//	/// <param name="info">シリアル化に必要なすべてのデータ</param>
//	/// <param name="context">シリアル化ストリームの転送元と転送先</param>
//	protected YahooJpVideoSearchResult(SerializationInfo info, StreamingContext context)
//	{
//		this.totalResultsReturned = info.GetInt32("totalResultsReturned");
//		this.totalResultsAvailable = info.GetInt64("totalResultsAvailable");
//		this.firstResultPosition = info.GetInt32("firstResultPosition");
//		//this.elementList = (List<ISearchResultElement>)info.GetValue("elementList", typeof(List<ISearchResultElement>));
//		this.resultElements = (YahooJpVideoElement[])info.GetValue("resultElements", typeof(YahooJpVideoElement[]));
//	}

	
	// IVideoSearchResult メンバ
	
//	IVideoElement[] IVideoSearchResult.ResultElements
//	{
//		get { return this.ResultElements; }
//	}
	
	//IVideoElement IVideoSearchResult.this[int index]
	//{
	//    get
	//    {
	//        return (IVideoElement)this.elementList[index];
	//    }
	//}
	

	
	// ISearchResult メンバ
	
//	ISearchResultElement[] ISearchResult.ResultElements
//	{
//		get { return this.ResultElements; }
//	}
//	
//	String ISearchResult.Query
//	{
//		get
//		{
//			return this.query;
//		}
//	}
//	
	public long getTotalNumber()
	{
		return this.totalResultsAvailable;
	}
	

}

