package slothLib.web.search;

/**
 * Yahoo! 画像検索結果の要素を格納する
 * 

 * <newpara>[2007-05-24][kondo]作成</newpara>
 */
// [Serializable]

public class YahooJpImageElement implements IImageElement, IRankedElement
{
//        #region privateフィールド

	int rank;
	
	String title;
	String summary;
	String url;
	String clickUrl;
	String refererUrl;
	String fileSize;
	String fileFormat;
	double height;
	double width;
	String thumbnailUrl;
	double thumbnailHeight;
	double thumbnailWidth;
	String publisher;
	boolean frameOk;
	boolean inlineOk;
	String copyright;
	

	
	// コンストラクタ

	/**
	 * コンストラクタ
	 * @param rank 画像ファイルのランキング
	 * @param title 画像ファイルのタイトル
	 * @param summary 画像ファイルに関連するテキストサマリー
	 * @param url 画像ファイルのURL
	 * @param clickUrl 画像ファイルへのリンクURL
	 * @param refererUrl 画像へのリンクを含むページのURL
	 * @param fileSize  ファイルサイズ 単位はbyte 
	 * @param fileFormat bmp、gif、jpegまたはpngのいずれか
	 * @param height 画像の高さ 単位はピクセル
	 * @param width 画像の幅 単位はピクセル
	 * @param thumbnailUrl サムネイル画像のURL
	 * @param thumbnailHeight サムネイル画像の高さ 単位はピクセル
	 * @param thumbnailWidth サムネイル画像の幅 単位はピクセル
	 * @param publisher 画像ファイルの提供者
	 * @param frameOk サイト内のフレームで表示してよいか
	 * @param inlineOk フレーム上のインラインオブジェクトとして表示してよいか
	 * @param copyright オーナーのコピーライト
	 */
	public YahooJpImageElement(int rank, String title, String summary, String url, String clickUrl,
			String refererUrl, String fileSize, String fileFormat, double height, double width, String thumbnailUrl, 
			double thumbnailHeight, double thumbnailWidth, String publisher, boolean frameOk, boolean inlineOk , String copyright)
	{
		this.rank = rank;
		this.title = title;
		this.summary = summary;
		this.url = url;
		this.clickUrl = clickUrl;
		this.refererUrl = refererUrl;
		this.fileSize = fileSize;
		this.fileFormat = fileFormat;
		this.height = height;
		this.width = width;
		this.thumbnailUrl = thumbnailUrl;
		this.thumbnailHeight = thumbnailHeight;
		this.thumbnailWidth = thumbnailWidth;
		this.publisher = publisher;
		this.frameOk = frameOk;
		this.inlineOk = inlineOk;
		this.copyright = copyright;
	}
	

	
	// #region プロパティ
	
	/**
	 * 画像ファイルのタイトル
	 */
	public String getTitle()
	{
		return this.title;
	}
	
	/**
	 * 画像ファイルに関連するテキストサマリー
	 */
	public String getSummary()
	{
		return this.summary;
	}
	
	/**
	 * 画像ファイルのURL
	 */
	public String getURL()
	{
		return this.url;
	}
	
	/**
	 * 画像ファイルへのリンクURL
	 */
	public String getClickUrl()
	{
		return this.clickUrl;
	}
	
	/**
	 * 画像へのリンクを含むページのURL
	 */
	public String getRefererUrl()
	{
		return this.refererUrl;
	}
	
	/**
	 * ファイルサイズ 単位はbyte
	 */
	public String getFileSize()
	{
		return this.fileSize;
	}
	
	/**
	 * bmp、gif、jpegまたはpngのいずれか
	 */
	public String getFileFormat()
	{
		return this.fileFormat;
	}
	
	/**
	 * 画像の高さ 単位はピクセル
	 */
	public double getHeight()
	{
		return this.height;
	}
	
	/**
	 * 画像の幅 単位はピクセル
	 */
	public double getWidth()
	{
		return this.width;
	}
	
	/**
	 * サムネイル画像のURL
	 */
	public String getThumbnailUrl()
	{
		return this.thumbnailUrl;
	}
	
	/**
	 * サムネイル画像の高さ 単位はピクセル
	 */
	public double getThumbnailHeight()
	{
		return this.thumbnailHeight;
	}
	
	/**
	 * サムネイル画像の幅 単位はピクセル
	 */
	public double getThumbnailWidth()
	{
		return this.thumbnailWidth;
	}
	
	/**
	 * 画像ファイルの提供者
	 */
	public String getPublisher()
	{
			return this.publisher;
	}
	
	/**
	 * サイト内のフレームで表示してよいか
	 */
	public boolean getFrameOk()
	{
		return this.frameOk;
	}
	
	/**
	 * フレーム上のインラインオブジェクトとして表示してよいか
	 */
	public boolean getInlineOk()
	{
		return this.inlineOk;
	}
	
	/**
	 * オーナーのコピーライト
	 */
	public String getCopyright()
	{
		return this.copyright;
	}
	

	
	// ToString
	
	//a/ <summary>
	/// オーバーライド
	/// </summary>
	/// <returns>Yahoo!画像検索結果要素の内容</returns>
	public String toString()
	{
		return "Title: " + title + "\r\n"
		+ "URL: " + url + "\r\n"
		+ "Summary: " + summary;
	}
	

	
	// ISearchResultElement メンバ
	
	/**
	 * ページのURL
	 */
	//String ISearchResultElement.URL
//	{
		//get { return this.URL; }
	//}
	
	/**
	 * ページのタイトル
	 */
	//String ISearchResultElement.Title
	//{
//		get { return this.Title; }
//	}
	
	/**
	 * ページの要約
	 */
	public String getDescription()
	{
		return this.getSummary();
	}
	
//	#endregion
	
//	#region IRankedElement メンバ
	
	/**
	 * 検索エンジンにつけられたランキング
	 */
	public int getRank()
	{
		return this.rank;
	}
	
//	#endregion
	
//	#region ISerializable メンバ
	
	/**
	 * シリアライズ化するときに呼び出される関数
	 * @param info 逆シリアル化に必要なすべてのデータ
	 * @param context シリアル化ストリームの転送元と転送先
	 */
//	void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
//	{
//		info.AddValue("rank", this.rank);
//		info.AddValue("title", this.title);
//		info.AddValue("summary", this.summary);
//		info.AddValue("url", this.url);
//		info.AddValue("clickUrl", this.clickUrl);
//		info.AddValue("referUrl", this.refererUrl);
//		info.AddValue("fileSize", this.fileSize);
//		info.AddValue("fileFormat", this.fileFormat);
//		info.AddValue("height", this.height);
//		info.AddValue("width", this.width);
//		info.AddValue("thumbnailUrl", this.thumbnailUrl);
//		info.AddValue("thumbnailHeight", this.thumbnailWidth);
//		info.AddValue("thumbnailWidth", this.thumbnailHeight);
//		info.AddValue("publisher", this.publisher);
//		info.AddValue("frameOk", this.frameOk);
//		info.AddValue("inlineOk", this.inlineOk);
//		info.AddValue("copyright", this.copyright);
//	}
//	
	/**
	 * シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
	 * @param info シリアル化に必要なすべてのデータ
	 * @param context シリアル化ストリームの転送元と転送先
	 */
//	protected YahooJpImageElement(SerializationInfo info, StreamingContext context)
//	{
//		this.rank = info.GetInt32("rank");
//		this.title = info.GetString("title");
//		this.summary = info.GetString("summary");
//		this.url = info.GetString("url");
//		this.clickUrl = info.GetString("clickUrl");
//		this.refererUrl = info.GetString("referUrl");
//		this.fileSize = info.GetString("fileSize");
//		this.fileFormat = info.GetString("fileFormat");
//		this.height = info.GetDouble("height");
//		this.width = info.GetDouble("width");
//		this.thumbnailUrl = info.GetString("thumbnailUrl");
//		this.thumbnailHeight = info.GetDouble("thumbnailHeight");
//		this.thumbnailWidth = info.GetDouble("thumbnailWidth");
//		this.publisher = info.GetString("publisher");
//		this.frameOk = info.GetBoolean("frameOk");
//		this.inlineOk = info.GetBoolean("inlineOk");
//		this.copyright = info.GetString("copyright");
//	}
//	
//	#endregion
//	
}
