package slothLib.web.search;

import java.io.Serializable;

    /**
     * Flickr 検索が返す検索結果全体。
     */
    public class FlickrSearchResult implements IImageSearchResult, Serializable
    {

        // コンストラクタ
        /**
         * コンストラクタ
         * @param query 検索クエリ
         * @param totalResultsAvailable データ内のマッチしたクエリー数です。
         * @param resultElemDesents 検索結果要素
         */
		public FlickrSearchResult(String query, long totalResultsAvailable, FlickrElement[] resultElements)
        {
            this.query = query;
            this.totalResultsAvailable = totalResultsAvailable;
            this.elementList = resultElements;
        }



        // privateフィールド

        private String query;

        private long totalResultsAvailable;
        private FlickrElement[] elementList;



        // プロパティ

        /**
         * 検索に使われたクエリ
         */
        public String getQuery()
        {
                return this.query;
        }

        /**
         * 検索総件数
         */
        public long getTotalResultsAvailable()
        {
        	return this.totalResultsAvailable;

        }

        /**
         * この検索結果に含まれる検索結果数
         */
        public int getTotalResultsReturned()
        {
        	return this.elementList.length;
        }
        
        
        /**
         * 得られた検索結果数
         */
        /*
         * public int Count
        {
            get
            {
                return this.elementList.Count;
            }
        }
        */

        /**
         *  検索結果要素の配列
         */
        public FlickrElement[] getResultElements()
        {
        	return elementList;
        }



//		//#region ISerializable メンバ
//
//        /// <summary>
//        /// シリアライズ化するときに呼び出される関数
//        /// </summary>
//        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//		void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
//		{
//            info.AddValue("query", this.query);
//			info.AddValue("totalResultsAvailable", this.totalResultsAvailable);
//			info.AddValue("elementList", this.elementList);
//		}
//
//        /// <summary>
//        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
//        /// </summary>
//        /// <param name="info">シリアル化に必要なすべてのデータ</param>
//        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
//		protected FlickrSearchResult(SerializationInfo info, StreamingContext context)
//		{
//            this.query = info.GetString("query");
//			this.totalResultsAvailable = info.GetInt64("totalResultsAvailable");
//            this.elementList = (FlickrElement[])info.GetValue("elementList", typeof(FlickrElement[]));
//		}
//
//		//#endregion

        // ISearchResult メンバ

        /**
         * 総検索数
         */
        public long getTotalNumber()
        {
        	return this.totalResultsAvailable;
        }

        /**
         * 検索に使われたクエリ
         */
//        String ISearchResult.Query
//        {
//            get
//            {
//                return this.query;
//
//            }
//        }

        /**
         *  検索結果要素の配列
         */
//        public ISearchResultElement[] getResultElements()
//        {
//                return this.ResultElements;
//        }



        // IImageSearchResult メンバ

        /**
         * 検索結果要素の配列
         */
//        IImageElement[] IImageSearchResult.ResultElements
//        {
//            get
//            {
//                return this.ResultElements;
//            }
//        }


    
    }

