package slothLib.portUtil;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import slothLib.web.search.WebSearchException;

public class PortUtil {
	public static boolean isNullOrEmpty(String str){
		return str == null || str.length() == 0;
	}


	public static <T> List<T> toList(T [] array){
		List<T> tmp = new ArrayList<T>();
		for (T t: array)
			tmp.add(t);
		return tmp;
	}

	public static Proxy createProxy(String uri){
		try {
			URI tmp = new URI(uri);
			SocketAddress addr = new InetSocketAddress(tmp.getHost(), tmp.getPort()); 
			return new Proxy(Proxy.Type.HTTP, addr); 
		} catch (URISyntaxException e) {
			e.printStackTrace();
			return null;
		}
	}

	public static boolean fileExists(String filename){
		return (new File(filename)).exists();
	}

	public static void fileDelete(String filename) throws IOException{
		(new File(filename)).delete();
	}
	
	public static boolean processExited(Process p){
		try {
			p.exitValue();
			return true;
		} catch (IllegalThreadStateException e) {
			return false;
		}
	}
	public static String getHttpVersion(HttpURLConnection con){
		return con.getHeaderField("HTTP-Version");
	}
	
	public static List<HttpCookie> getCookies(HttpURLConnection con){
		return new ArrayList<HttpCookie>();
		// TODO : real job here
	}
	
	public static String getCharacterSet(HttpURLConnection con){
		return con.getHeaderField("charset");
	}

	public static Document getDocumentFromURL(String requestURL, Proxy proxy) throws WebSearchException{
		int statusCode;
		HttpURLConnection con;
		Document xmlDoc = null;
		try {
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = null;
			builder = dbfactory.newDocumentBuilder();
			if (proxy != null)
			{
				con = (HttpURLConnection)(new URL(requestURL)).openConnection(proxy);
			}
			else
			{
				con = (HttpURLConnection)(new URL(requestURL)).openConnection();
			}
			InputStream is = con.getInputStream();
			xmlDoc = builder.parse(is);
			statusCode = con.getResponseCode();
			
			
		} catch (IOException e){
			throw new WebSearchException(e);
		} catch (ParserConfigurationException e) {
			throw new WebSearchException(e);
		} catch (SAXException e) {
			throw new WebSearchException(e);				
		}
		
		
		//Errorが帰ってきた場合
		//if (xmlRoot.Name.Equals("Error"))
		if (statusCode != HttpURLConnection.HTTP_OK)
		{
			Element xmlRoot = xmlDoc.getDocumentElement();
			// 例外メッセージを取得
			String errorMessage = getElementString(xmlRoot.getElementsByTagName("Message"));
			// 例外を投げる。
			throwException(statusCode, errorMessage);
		}
		return xmlDoc;
	}
	
    private static String getElementString(NodeList nodeList)
    {
        if (nodeList.getLength() == 0)
        {
            return null;
        }
        else
        {
        	return nodeList.item(0).getTextContent();
        }
    }

	private static void throwException(int errorCode, String errorMessage) throws WebSearchException
	{
		switch (errorCode)
		{
			case HttpURLConnection.HTTP_BAD_REQUEST: // 400
				throw new WebSearchException(WebSearchException.HttpCode.BadRequest, errorMessage);
			case HttpURLConnection.HTTP_FORBIDDEN: // 403
				throw new WebSearchException(WebSearchException.HttpCode.Forbidden, errorMessage);
			case HttpURLConnection.HTTP_UNAVAILABLE: // 503
				throw new WebSearchException(WebSearchException.HttpCode.ServiceUnavailable, errorMessage);
			default:
                throw new WebSearchException(WebSearchException.HttpCode.Unknown, "YahooWebSearchで想定外のHTTPエラーが発生しました。（エラーコード: " + (int)errorCode + "）" + errorMessage);
        }
	}

	public static String absoluteUri(String uriString)
	{
		URI uri;
		try {
			uri = new URI(uriString);
		} catch (URISyntaxException e) {
			e.printStackTrace();
			return uriString;
		}
		String result = uri.normalize().toString();
		return result;
	}
	public static String getProxyURL(Proxy proxy)
	{
		if (proxy == null)
			return null;
		InetSocketAddress addr = (InetSocketAddress)proxy.address();
		String tmp = "http://" + addr.getHostName() + ":" + addr.getPort() + "/";
		return tmp;
	}
	
	public static String readFully(InputStream is, String encoding) throws IOException{
		LineNumberReader reader = new LineNumberReader(new InputStreamReader(is, encoding));
		// read fully
		StringBuffer sb = new StringBuffer();
		String tmp;
		while ((tmp = reader.readLine()) != null)
			sb.append(tmp + "\n");
		return sb.toString(); 
		
	}

	/**
	 * 
	 * @param is
	 * @param buffer
	 * @param off
	 * @param len
	 * @return number of bytes acturally read.
	 * @throws IOException
	 */
	public static int readFully(InputStream is, byte[] buffer, int off, int len) throws IOException{
		int orgOff = off;
		while (len > 0){
			int num = is.read(buffer, off, len);
			if (num < 0) 
				break;
			off += num;
			len -= num;
		}
		return off - orgOff;
	}

	private static String BROWSER = "firefox";
	
	
	public static void openUrl(String openURL) {
		ProcessBuilder pb = new ProcessBuilder(); 
		pb.command(BROWSER, openURL);
		try {
			pb.start();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	

}