package slothLib.linearAlgebra.vector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class VectorCollection {
	private ArrayList<BasicVector> vectorList = new ArrayList<BasicVector>(); 
	private int _dimension;

	
	
	public BasicVector get(int index){
		if (index >= 0 && index < this.vectorList.size())
		{
			return this.vectorList.get(index);
		}
		else
		{
			throw new ArrayIndexOutOfBoundsException("index");
		}

	}
	
	public int dimension(){
		return _dimension;
	}
	
	public int count() {
		return vectorList.size();
	}
	
	
	
	
	
	/***************************************************
	 */
	
	public boolean add(BasicVector item) {
		if (item.dimension() != this.dimension())
			throw new IllegalArgumentException("与えられるベクトルのベクトル空間は全て同じでなくてはいけません。");
		return vectorList.add(item);

	}

	public boolean addAll(Collection<BasicVector> c) {
		return vectorList.addAll(c);
	}

	public void clear() {
		vectorList.clear();
	}

	public boolean contains(BasicVector o) {
		return vectorList.contains(o);
	}

	public boolean containsAll(Collection<BasicVector> c) {
		return containsAll(c);
	}

	public boolean isEmpty() {
		return isEmpty();
	}

	public Iterator iterator() {
		return vectorList.iterator();
	}

	public boolean remove(BasicVector o) {
		return vectorList.remove(o);
	}

	public boolean removeAll(Collection<BasicVector> c) {
		return vectorList.removeAll(c);
	}

	public boolean retainAll(Collection<BasicVector> c) {
		return vectorList.retainAll(c);
	}

	public int size() {
		return vectorList.size();
	}

	public BasicVector[] toArray() {
		return (BasicVector[])vectorList.toArray();
	}

	public BasicVector[] toArray(BasicVector[] a) {
			return vectorList.toArray(a);
	}
	
}