package slothLib.linearAlgebra.vector;

public interface IVector extends Cloneable {

	/**
	 * 指定した次元における値。
	 * @param dimension 次元
	 * @return 指定した次元における値
	 */
	double get(int dimension);
	void   set(int dimension, double value);

	/**
	 * ベクトルの次元数
	 */
	int dimension();

	/**
	 * ベクトルを表すdouble配列のコピー
	 */
	double[] getPlainVector();

	Object clone();
}
