package slothLib.linearAlgebra.vector;

public final class BasicVector extends AbstractVector {

	/**
	 * ベクトルの本体である配列
	 */
	private double[] vector;

	/**
	 * コンストラクタ
	 * @param dimension 
	 */
	public BasicVector(int dimension)
	{
		this.vector = new double[dimension];
	}

	/**
	 * コンストラクタ
	 * @param doubleArray 
	 */
	public BasicVector(double[] doubleArray){
		this(doubleArray.length);
		System.arraycopy(doubleArray, 0, this.vector, 0, doubleArray.length);
	}

	/**
	 * コンストラクタ
	 * @param vector 
	 */
	public BasicVector(IVector vector)
	{
		this(vector.dimension());
		for (int i = 0; i < vector.dimension(); i++)
		{
			this.vector[i] = vector.get(i);
		}
	}

	/**
	 * 指定した次元における値。
	 * @param dimension 次元
	 * @return 指定した次元における値
	 */

	public double get(int dimension){		
		return this.vector[dimension];
	}
		
	public void set(int dimension, double value){
		this.vector[dimension] = value;
	}

	/**
	 * ベクトルの次元数
	 */
	public int dimension(){
		return this.vector.length;
	}

	/**
	 * ベクトルを表すdouble配列のコピー
	 */
	public double[] getPlainVector()
	{
		//double[] r = new double[this.Dimension];
		//this.vector.CopyTo(r, 0);
		//return r;
		return (double[])this.vector.clone();
	}

	/**
	 * ベクトルのクローンを返す。
	 */
	public Object clone()
	{
		return new BasicVector(this.getPlainVector());
	}
}
