package slothLib.linearAlgebra.matrix;


/**
 * 転置行列を求めるクラス
 * Value[i, j] = Value[j, i];
 */

public class TransposedMatrix extends BasicMatrix {

	public TransposedMatrix(IMatrix matrix)
    {
        super(matrix.columnCount(), matrix.rowCount());
        this.calculate(matrix);
    }
	
	private void calculate(IMatrix matrix){
		for (int i = 0; i < this.rowCount(); i++)
        {
        	for (int j = 0; j < this.columnCount(); j++)
            {
            	set(i, j, matrix.get(j, i));
            }
        }
	}

}
