package slothLib.linearAlgebra.matrix;

/**
 * 2つの行列の積を求めるクラス
 * 積の定義はアーサー・ケーリーに従う
 */
public class MultiplyMatrix extends BasicMatrix {
    /**
	 * コンストラクタ
	 * @param matrix1 
	 * @param matrix2 
     */
	public MultiplyMatrix(IMatrix matrix1, IMatrix matrix2)
	{
		super(matrix1.rowCount(), matrix2.columnCount());    
		if (matrix1.columnCount() != matrix2.rowCount())
        {
            // 現時点ではエラーを投げて終了
            throw new IllegalArgumentException("左行列の列数と右行列の行数が一致しません");
        }

        this.format();
        this.calculate(matrix1, matrix2);
    }

    
    private void format()
    {
        for (int i = 0; i < this.rowCount(); i++)
        {
            for (int j = 0; j < this.columnCount(); j++)
            {
                this.set(i, j, 0.0); // was default(double);
            }
        }
    }

    private void calculate(IMatrix matrix1, IMatrix matrix2)
    {
        for (int i = 0; i < this.rowCount(); i++)
        {
            for (int j = 0; j < this.columnCount(); j++)
            {
                // 結果の要素1つ1つを計算
                // まずは初期化
                this.set(i, j, 0.0); // default(double);

                // sum (matrix0.column * matrix1.row) 
                for (int k = 0; k < matrix2.rowCount(); k++)
                {
                	this.set(i, j,  this.get(i, j) + matrix1.get(i, k) * matrix2.get(k, j));
                }
            }
        }
    }

}
