package slothLib.linearAlgebra.matrix;

public class AugNormMatrix extends BasicMatrix {
    private final double MIN = 0.5;
    private final double MAX = 1.0;

    /**
     * コンストラクタ
     * @param matrix 
     */
    public AugNormMatrix(IMatrix matrix)
    {
        super(matrix.rowCount(), matrix.columnCount());

    	double absMax = MatrixOperator.getMaxNorm(matrix);

        for (int i = 0; i < matrix.rowCount(); i++)
        {
            for (int j = 0; j < matrix.columnCount(); j++)
            {
                if (absMax != 0.0)
                {
                	set(i, j, MIN + (MAX - MIN) * matrix.get(i, j) / absMax);
                }
                else
                {
                	set(i, j, 0.0); // was default(double);
                }
            }

        }
    }

}
