package slothLib.linearAlgebra.matrix;

public class AddMatrix extends BasicMatrix {
    /**
     * コンストラクタ
     * @param matrixs 
     */
    public AddMatrix(IMatrix... matrixs)
    {
    	super(matrixs[0].rowCount(), matrixs[0].columnCount());

    	for (IMatrix matrix: matrixs)
        {
            if ((this.rowCount() != matrix.rowCount()) || (this.columnCount() != matrix.columnCount()))
            {
                // 現時点ではエラーを投げて終了
                throw new IllegalArgumentException("各行列の行数及び列数が一致しません");
            }
        }

        this.format();

        this.calculate(matrixs);
    }


    /**
     * 行列の値を初期化する
     */
    private void format()
    {
        for (int i = 0; i < this.rowCount(); i++)
        {
            for (int j = 0; j < this.columnCount(); j++)
            {
                this.set(i, j, 0.0); //default(double)
            }
        }
    }

    /**
     * 行列の加算を行う
     * @param matrixs 
     */
    private void calculate(IMatrix[] matrixs)
    {
        for (IMatrix matrix: matrixs)
        {
            for (int i = 0; i < this.rowCount(); i++)
            {
                for (int j = 0; j < this.columnCount(); j++)
                {
                	this.set(i, j, this.get(i, j) + matrix.get(i, j));
                }
            }
        }
    }
	


}
