package slothLib.linearAlgebra.featureVector;

public class AugNormVector<T> extends BasicVector<T> {
	public AugNormVector(IVector<T> vector) {
		double absmax = VectorOperator.getMaxNorm(vector);
		
		for (T key: vector.keys()) {
			if (absmax != 0) 
				this.set(key, 0.5 + 0.5 * vector.get(key) / absmax);
			else
                this.set(key, 0);
        }
    }
}
