package slothLib.linearAlgebra.featureVector;

import java.util.Collection;


public class AddVector <T> extends BasicVector <T> {
	
	public AddVector(Collection<IVector <T> > vectors){
		for (IVector<T> vector: vectors)
			calculate(vector);
	}

	public AddVector(IVector <T> ...vectors ){
		for (IVector<T> vector: vectors)
			calculate(vector);
	}

	public void calculate(IVector<T> vector){
		for (T key: vector.keys())
			if (this.containsKey(key))
				this.set(key, this.get(key) + vector.get(key));
			else
				this.set(key, vector.get(key));
	}
	

}
