package slothLib.linearAlgebra.featureVector;

public abstract class AbstractVector<T> implements IVector<T> {

	
	public IVector<T> op_add(IVector<T> vector2){
		return VectorOperator.add(this, vector2);
	}

	public IVector<T> op_sub(IVector<T> vector2){
		return VectorOperator.subtract(this, vector2);
	}

	public IVector<T> op_negate(){
		return VectorOperator.negate(this);
	}

	public IVector<T> op_mul(double scalar){
		return VectorOperator.multiply(scalar, this);
	}

	public abstract double[] getPlainVector();

	public abstract Object clone();
	
}
