package slothLib.linearAlgebra.featureVector;

/**
 * 最短距離法
 * <typeparam name="T"></typeparam>
 */
public class SingleLinkageClustering<T> extends HierarchicalClustering<T>
{

	/**
	 * 距離を距離テーブル作成に用いる
	 * @param distanceCalculator 
	 */
	public SingleLinkageClustering(IDistanceCalculator<T> distanceCalculator)
	{
		super(distanceCalculator);
	}

	/**
	 * 類似度を距離テーブル作成に用いる
	 * @param similarityCalculator 
	 */
	public SingleLinkageClustering(ISimilarityCalculator<T> similarityCalculator)
	{
		super(similarityCalculator);
	}

	/**
	 * クラスタリングを実際に行うクラスを返す
	 * @param vectors 
	 * @return 
	 */
	protected IHierarchicalClusteringProcess<T> getProcess(IVector<T>[] vectors)
	{
		return new SingleLinkageClusteringProcess<T>(vectors, this.calculator, this.dType);
	}


}
