package slothLib.linearAlgebra.featureVector;

public class DendrogramNode<T> implements IDendrogramNode<T> {

	private int iid1;
	private int iid2;
	private double distance;

	/**
	 * コンストラクタ
	 * @param iid1 
	 * @param iid2 
	 * @param distance 
	 */
	public DendrogramNode(int iid1, int iid2, double distance)
	{
		this.iid1 = iid1;
		this.iid2 = iid2;
		this.distance = distance;
	}

	/**
	 * IDが小さい方のクラスタ番号
	 */
	public int itemID1()
	{
		return this.iid1; 
	}

	/**
	 * IDが大きい方のクラスタ番号
	 */
	public int itemID2()
	{
		return this.iid2; 
	}

	/**
	 * 接点における距離
	 * 類似度の場合も類似度そのまま
	 */
	public double distance()
	{
		return this.distance;
	}

	/**
	 * 重心のベクトル
	 */
	public IVector<T> centroidVector() 
	{
		return null;
	}

}
