package slothLib.linearAlgebra.featureVector;

/**
 * セントロイド法
 * セントロイド法における距離計算はユークリッド距離を用いるべきであるため、EuclideanDistanceCalculatorを使用すること。
 * <typeparam name="T"></typeparam>
 */
public class CentroidClustering<T> extends HierarchicalClustering<T>{
	/**
	 * 距離を距離テーブル作成に用いる
	 * @param distanceCalculator 
	 */
	public CentroidClustering(IDistanceCalculator<T> distanceCalculator)
	{
		super(distanceCalculator);
	}

	/**
	 * 類似度を距離テーブル作成に用いる
	 * @param similarityCalculator 
	 */
	public CentroidClustering(ISimilarityCalculator<T> similarityCalculator)
	{
		super(similarityCalculator);
	}

	/**
	 * クラスタリングを実際に行うクラスを返す
	 * @param vectors 
	 * @return 
	 */
	protected IHierarchicalClusteringProcess<T> getProcess(IVector<T>[] vectors)
	{
		return new CentroidClusteringProcess<T>(vectors, this.calculator, this.dType);
	}
	
}
