
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import slothLib.web.search.GoogleSOAPSearchAPI;
import slothLib.web.search.GoogleSOAPSearchAPIResult;
import slothLib.web.search.IWebElement;
import slothLib.web.search.WebSearchException;

public class WebSample {

	private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="10,10"
	private Button button = null;
	private Text text = null;
	private Text textArea = null;

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO 自動生成されたメソッド・スタブ
		/* Before this is run, be sure to set up the launch configuration (Arguments->VM Arguments)
		 * for the correct SWT library path in order to run with the SWT dlls. 
		 * The dlls are located in the SWT plugin jar.  
		 * For example, on Windows the Eclipse SWT 3.1 plugin jar is:
		 *       installation_directory\plugins\org.eclipse.swt.win32_3.1.0.jar
		 */
		Display display = Display.getDefault();
		WebSample thisClass = new WebSample();
		thisClass.createSShell();
		thisClass.sShell.open();

		while (!thisClass.sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		GridData gridData1 = new GridData();
		gridData1.grabExcessVerticalSpace = true;
		gridData1.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData1.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData1.horizontalSpan = 2;
		GridData gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		sShell = new Shell();
		sShell.setText("Shell");
		sShell.setLayout(gridLayout);
		sShell.setSize(new Point(471, 372));
		text = new Text(sShell, SWT.BORDER);
		text.setLayoutData(gridData);
		button = new Button(sShell, SWT.NONE);
		button.setText("検索");
		button.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				System.out.println("widgetSelected()"); // TODO Auto-generated Event stub widgetSelected()
			//	textArea.setText(text.getText());
				textArea.setText(searchYahoo(text.getText()));
			}
		});
		textArea = new Text(sShell, SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		textArea.setLayoutData(gridData1);
	}
	
	
	/**
	 * search
	 */
	private String searchYahoo(String text) {
		StringBuffer sb = new StringBuffer();

//		YahooJpWebSearch ws = new YahooJpWebSearch("slothlib");
//		YahooJpWebSearchResult result;
		try {
			GoogleSOAPSearchAPI ws = new GoogleSOAPSearchAPI();
			GoogleSOAPSearchAPIResult result;
			result = ws.doSearch(text, 10);
			for (IWebElement element: result.getResultElements())
				sb.append(element.getTitle() + "\n");
			return sb.toString();
		} catch (WebSearchException e) {
			return e.getMessage();
		}
		
	}
	
}
