//using System;
//using System.Collections.Generic;
//using System.Text;

package slothLib.text;

import slothLib.SlothLibException;

	/**
	 * 文字コード変換のためのクラスに共通のインターフェース
	 */
	public interface IEncodingConverter
	{
		/**
		 * テキストファイルの文字コード変換を行う。
		 * @param textFilePath テキストファイルのパス
		 */
		EncodingConverterResult convertTextFile(String textFilePath)
		throws SlothLibException;

		/**
		 * バイト列の文字コード変換を行う。
		 * @param byteArray バイト列
		 */
		EncodingConverterResult convertByteArray(byte [] byteArray)
		throws SlothLibException;
	}
