package slothLib.NLP;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 品詞情報が付加された語の並びを格納するクラス
 */
public class PosTaggerResult implements IPosTaggerResult
{
	/**
	 * 品詞情報付き語のリスト
	 */
	protected List<PosTaggedWord> posTaggedWordList;
	
	/**
	 * コンストラクタ
	 */
	public PosTaggerResult()
	{
		this.posTaggedWordList = new ArrayList<PosTaggedWord>();
	}
	
	/**
	 * コンストラクタ
	 * @param posTaggedWords もととなるIterable
	 */
	public PosTaggerResult(Collection<PosTaggedWord> posTaggedWords)
	{
		this.posTaggedWordList = new ArrayList<PosTaggedWord>(posTaggedWords);
	}
	
	/**
	 * 格納している語の配列
	 */
	public PosTaggedWord[] posTaggedWords()
	{
		return this.posTaggedWordList.toArray(new PosTaggedWord[0]);
	}
	
	
	/**
	 * 各語のRawを配列にして返す
	 * @return Rawの配列
	 */
	public String[] getRawArray()
	{
		List<String> rawList = new ArrayList<String>();
		for (IPosTaggedWord word: this.posTaggedWordList)
		{
			rawList.add(word.getRaw());
		}
		return (String[])(rawList.toArray());
	}
	
	/**
	 * 各語のPOSを配列にして返す
	 * @return POSの配列
	 */
	public String[] getPOSArray()
	{
		List<String> posList = new ArrayList<String>();
		for (IPosTaggedWord word: this.posTaggedWordList)
		{
			posList.add(word.getPOS());
		}
		return (String[])(posList.toArray());
	}
	
	
/*
 *  don't know what to do	
	IPosTaggedWord[] IPosTaggerResult.PosTaggedWords()
	{
		return this.posTaggedWordList.ToArray(); }
	}
	*/		
}
