package slothLib.NLP;
import java.util.regex.Pattern;

/// <summary>
/// 正規表現を使って語を取り除くフィルタ。
/// StopWordFilterやPosFilterでは扱えないもの用
/// </summary>
/// <remarks>
/// <newpara>[2007-05-23][inagawa]作成</newpara>
/// </remarks>
public class RegexFilter extends AbstractStringFilter
{
	private Pattern include;
	private Pattern exclude;
	
	/// <summary>
	/// コンストラクタ。includeにマッチし、かつexcludeにマッチしないものが残る
	/// </summary>
	/// <param name="include">残したい文字列にマッチする正規表現</param>
	/// <param name="exclude">除外したい文字列にマッチする正規表現</param>
	public RegexFilter(Pattern include, Pattern exclude)
	{
		this.include = include;
		this.exclude = exclude;
	}
	
		
	/// <summary>
	/// 正規表現を使って語を取り除く
	/// </summary>
	/// <param name="str">フィルタを適用する文字列</param>
	/// <returns>フィルタ適用後の文字列</returns>
	public String doFilter(String str)
	{
		return Filter.regexFilter(str, include, exclude);
	}
}

