package slothLib.NLP;
	/// <summary>
	/// 文字列に対するフィルタのインターフェース
	/// </summary>
public interface IStringFilter
{
	/// <summary>
	/// 文字列に対してフィルタ操作を行う
	/// </summary>
	/// <param name="str">フィルタを適用する文字列</param>
	/// <returns>フィルタ適用後の文字列</returns>
	String doFilter(String str);
	/// <summary>
	/// 文字列の配列に対してフィルタ操作を行う
	/// </summary>
	/// <param name="Strings">フィルタを適用する文字列の配列</param>
	/// <returns>フィルタ適用後の文字列の配列</returns>
	String[] doFilter(Iterable<String> Strings);
	
	String[] doFilter(String Strings[]);
}

