package slothLib.NLP;

/// <summary>
/// 形態素に対するフィルタリングを行うインターフェース
/// </summary>
/// <remarks>
/// 
/// <newpara>[2007-04-21][ohshima]作成</newpara>
/// </remarks>
public interface IMorphemeFilter
{
	/// <summary>
	/// 形態素を入力し，処理後の形態素を出力する
	/// </summary>
	/// <param name="morpheme">フィルタを適用する形態素</param>
	/// <returns>フィルタ適用後の形態素</returns>
	IMorpheme doFilter(IMorpheme morpheme);

	/// <summary>
	/// 形態素の配列を入力し，処理後の形態素の配列を出力する
	/// </summary>
	/// <param name="morphemes">フィルタを適用する形態素の配列</param>
	/// <returns>フィルタ適用後の形態素の配列</returns>
	IMorpheme[] doFilter(Iterable<IMorpheme> morphemes);
	
	IMorpheme[] doFilter(IMorpheme[] morphemes);
	
	


}

