package slothLib.NLP;

import java.util.ArrayList;
import java.util.List;

/// <summary>
/// IMorphemeToStringFilterを実装するクラスのための抽象クラス
/// </summary>
public abstract class AbstractMorphemeToStringFilter implements IMorphemeToStringFilter
{
	// / <summary>
	// / 形態素にフィルタを適用する
	// / </summary>
	// / <param name="morpheme">フィルタを適用する形態素</param>
	// / <returns>フィルタによって変換された結果の文字列</returns>
	public abstract String doFilter(IMorpheme morpheme);
	
	// / <summary>
	// / 複数の形態素にフィルタを適用する
	// / </summary>
	// / <param name="morphemes">フィルタを適用する形態素</param>
	// / <returns>フィルタによって変換された結果の文字列の配列</returns>
	public String[] doFilter(Iterable<IMorpheme> morphemes)
	{
		List<String> result = new ArrayList<String>();
		for (IMorpheme mp: morphemes)
		{
			String filtered = this.doFilter(mp);
			if (filtered != null)
			{
				result.add(filtered);
			}
		}
		return result.toArray(new String[0]);
	}

	// / <summary>
	// / 複数の形態素にフィルタを適用する
	// / </summary>
	// / <param name="morphemes">フィルタを適用する形態素</param>
	// / <returns>フィルタによって変換された結果の文字列の配列</returns>
	public String[] doFilter(IMorpheme [] morphemes)
	{
		List<String> result = new ArrayList<String>();
		for (IMorpheme mp: morphemes)
		{
			String filtered = this.doFilter(mp);
			if (filtered != null)
			{
				result.add(filtered);
			}
		}
		return result.toArray(new String[0]);
	}

}

