package slothLib.NLP;

import java.util.ArrayList;
import java.util.List;

/// <summary>
/// IMorphemeFilterを実装するクラスのための抽象クラス。
/// </summary>
/// <remarks>
/// 
/// <newpara>[2007-05-10][ohshima]作成</newpara>
/// </remarks>
public abstract class AbstractMorphemeFilter implements IMorphemeFilter
{
	// / <summary>
	// / 形態素にフィルタを適用する
	// / </summary>
	// / <param name="morpheme">フィルタを適用する形態素</param>
	// / <returns>フィルタ適用後の形態素</returns>
	public abstract IMorpheme doFilter(IMorpheme morpheme);
	
	// / <summary>
	// / 複数の形態素にフィルタを適用する
	// / </summary>
	// / <param name="morphemes">フィルタを適用する形態素</param>
	// / <returns>フィルタ適用後の形態素の配列</returns>
	public IMorpheme[] doFilter(Iterable<IMorpheme> morphemes)
	{
		List<IMorpheme> result = new ArrayList<IMorpheme>();
		for (IMorpheme mp: morphemes)
		{
			IMorpheme filtered = this.doFilter(mp);
			if (filtered != null)
			{
				result.add(filtered); // nullでなければ追加する
			}
		}
		return result.toArray(new IMorpheme[0]);
	}

	// / <summary>
	// / 複数の形態素にフィルタを適用する
	// / </summary>
	// / <param name="morphemes">フィルタを適用する形態素</param>
	// / <returns>フィルタ適用後の形態素の配列</returns>
	public IMorpheme[] doFilter(IMorpheme []morphemes)
	{
		List<IMorpheme> result = new ArrayList<IMorpheme>();
		for (IMorpheme mp: morphemes)
		{
			IMorpheme filtered = this.doFilter(mp);
			if (filtered != null)
			{
				result.add(filtered); // nullでなければ追加する
			}
		}
		return result.toArray(new IMorpheme[0]);
	}
}
