//using System;
//using System.Collections.Generic;
//using System.Text;
//using System.IO;

package slothLib.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import slothLib.SlothLibException;
import slothLib.portUtil.PortUtil;
	/**
	 * pdftotextを使ってpdfファイルから内容を取得する
	 */
	public class PdftotextReader extends AbstractContentReader
	{

		
		private static String PDFTOTEXTREADER_TAG = "slothlib.pdftotext.path"; 
		private static String PDFTOTEXT_DEFAULT = "/usr/bin/pdftotext";
		
		//pdftotext.exeのパス
		private String pdftotextExePath = null;

		/**
		 * コンストラクタ
		 * @param pdftotextExePath Xdoc2txt.exeのパス
		 */
		public PdftotextReader(String pdftotextExePath) throws SlothLibException
		{
			super(".pdf");
			if (pdftotextExePath == null)
				pdftotextExePath = PDFTOTEXT_DEFAULT;
			if (PortUtil.fileExists(pdftotextExePath))
			{
				this.pdftotextExePath = pdftotextExePath;
			}
			else
			{
				throw new SlothLibException("指定されたpdftotextが見つかりませんでした" + pdftotextExePath);
			}
		}

		public PdftotextReader()throws SlothLibException
		{
			this(System.getProperty(PDFTOTEXTREADER_TAG));
		}

		/**
		 * ファイルからテキストを抽出する。
		 * 対応しているかどうかはReadableを用いる。
		 * @param filePath ファイルのパス
		 * @return 抽出された内容
		 */
		protected String process(String filePath) throws SlothLibException
		{
			
			Process p = null;
			try {
				List<String> cmds = new ArrayList<String>(); 
				cmds.add(this.pdftotextExePath);
				cmds.add(filePath);
				cmds.add("-");

				ProcessBuilder pb = new ProcessBuilder(cmds); 
				p = pb.start();
				String output = PortUtil.readFully(p.getInputStream(), "UTF-8");
				while (true) {
					try {
						p.waitFor();
						break;
					} catch (InterruptedException e){}
				}
				int ec = p.exitValue();			
				
				if (ec != 0)
				{
					System.err.println(PortUtil.readFully(p.getErrorStream(), "UTF-8"));
					throw new SlothLibException("pdftotextの実行時にエラーが起こりました。");
				}
				return output;

			} catch (IOException e){
				throw new SlothLibException(e);
			} finally {			
				p.destroy();
			}
			
		}


	}

