//using System;
//using System.Collections.Generic;
//using System.Text;

package slothLib.io;

import slothLib.SlothLibException;

	/**
	 * ファイルから内容を取得するクラスが持つべきインターフェース
	 * [2006-11-12][ohshima] 作成
	 */
	public interface IContentReader
	{

		/**
		 * 引数で与えられた拡張子に対応しているかどうか
		 * @param extension ピリオド付きの拡張子
		 * @return 読み込み可能かどうか
		 */
		boolean isReadable(String extension);

		/**
		 * ファイルからテキストを抽出する。
		 * 対応しているかどうかはReadableを用いる。
		 * @param filePath ファイルのパス
		 * @return 抽出された内容
		 */
		String read(String filePath) throws SlothLibException;


	}

