using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Web;
using System.Net;
using System.IO;
using System.Collections;

namespace SlothLib.Web.Search
{
	/// <summary>
	/// Yahoo!EFuWebT[rX
	/// http://developer.yahoo.co.jp/search/web/V1/webSearch.html
	/// </summary>
	/// <remarks>
	/// 
	/// <newpara>[2007-03-04][ohshima]쐬</newpara>
	/// <newpara>[2007-05-09][ohshima]C</newpara>
	/// </remarks>
	public class YahooJpWebSearch : IWebSearch
	{

		#region vCx[gtB[h

		// AvP[VID
		private string applicationID;

		// query  results(resultNumber) ȊÖ
		private SearchType type;
		private int start;
		private SearchFormat format;
		private bool adultOk;
		private bool similarOk;
		private string language;
		private string country;
		private string[] site;

        //ʂJԂȂ悤ɂ邽߂ɕKv
        Dictionary<string, bool> alreadyGotURL = new Dictionary<string, bool>();

        // XML̂߂̃[v񐔃JE^
        private int loopCount = 0;
        
        // proxy
		private WebProxy proxy;

		#endregion

		
		#region RXgN^

		/// <summary>
		/// RXgN^
		/// AvP[VIDw肷
		/// </summary>
		/// <param name="applicationID">vOŗpAvP[VID</param>

		public YahooJpWebSearch(string applicationID)
		{
			this.applicationID = applicationID;

			// query  resultNumber ȊÖ
			this.type= SearchType.all;
			this.start= 1;
			this.format = SearchFormat.any;
			this.adultOk = false;
			this.similarOk = false;
			this.language = "ja";
			this.country = null;
			this.site = null;
		}

		#endregion


		#region public \bh

		/// <summary>
		/// Yahoo!EFus
		/// </summary>
		/// <param name="query">NG[łB̃NG[Yahoo!̑ST|[gA܂^L[[h܂݂܂B</param>
		/// <param name="maxNumber">ԋpʂ̐łB</param>
		/// <returns>YahooJapanWebSearchResult^̌</returns>
		public YahooJpWebSearchResult DoSearch(string query, int maxNumber)
		{
            alreadyGotURL.Clear();
			return DoSearchOver(query, maxNumber);
		}


		/// <summary>
		/// HIT݂̂擾郁\bh
		/// </summary>
		/// <param name="query">NG</param>
		/// <returns>HIT</returns>
		public long GetTotalNumber(string query)
		{
			return DoSearch(query, 1).TotalResultsAvailable;
		}

		#endregion


		#region vpeB

		/// <summary>
		/// w茟̎ ftHgall
		/// </summary>
		public SearchType Type
		{
			get
			{
				return this.type;
			}
			set
			{
				this.type = value;
			}
		}

		/// <summary>
		/// t@C̎ށ@ftHgany
		/// </summary>
		public SearchFormat Format
		{
			get
			{
				return this.format;
			}
			set
			{
				this.format = value;
			}
		}

		/// <summary>
		/// A_gRečʂ܂߂邩ǂw肵܂BftHgfalse
		/// </summary>
		public bool AdultOk
		{
			get
			{
				return this.adultOk;
			}
			set
			{
				this.adultOk = value;
			}
		}

		/// <summary>
		/// Recʂ̌ʂƂ邩ǂw肵܂BftHgfalse
		/// </summary>
		public bool SimilarOk
		{
			get
			{
				return this.similarOk;
			}
			set
			{
				this.similarOk = value;
			}
		}

		/// <summary>
		/// languageŏꂽʂɂȂ܂BuT|[gĂ錾vQƂBftHg"ja"
		/// </summary>
		public string Language
		{
			get
			{
				return this.language;
			}
			set
			{
				this.language = value;
			}
		}

		/// <summary>
		/// EFuTCgʒu鍑̍R[hłBftHg͋󕶎
		/// </summary>
		public string Country
		{
			get
			{
				return this.country;
			}
			set
			{
				this.country = value;
			}
		}

		/// <summary>
		/// >hCiႦ www.yahoo.co.jpj𐧌܂B30hC܂Ŏw肷邱Ƃł܂BftHgnull
		/// </summary>
		public string[] Site
		{
			get
			{
				return this.site;
			}
			set
			{
				this.site = value;
			}
		}

		#endregion


		#region Proxyݒ

		/// <summary>
		/// vNV擾Eݒ肷B
		/// </summary>
        public string Proxy
        {
            set
            {
                if ( string.IsNullOrEmpty(value))
                {
                    this.proxy = null;
                }
                else
                {
                    this.proxy = new WebProxy(value);
                }
            }
            get
            {
                return this.proxy.Address.AbsoluteUri;
            }
        }

		#endregion


		#region t@\̌\bh

        /// <summary>
		/// 50܂łYahoo!EFus
		/// </summary>
		/// <param name="query">NG[łB̃NG[Yahoo!̑ST|[gA܂^L[[h܂݂܂B</param>
		/// <param name="results">ԋpʂ̐łB</param>
		/// <param name="start">ԋpʂ̐擪ʒułBŏIʒuistart + results - 1j́A1000𒴂܂B</param>
		/// <returns>YahooWebSearchResult^̌</returns>
		private YahooJpWebSearchResult DoSearchOriginal(string query, int results, int start)
		{
			string requestURL = MakeRequestURL(query, this.type, results, start, this.format, this.adultOk, this.similarOk, this.language, this.country, this.site);
			//System.Diagnostics.Debug.WriteLine(requestURL);
			XmlDocument xmlDoc = new XmlDocument();

			HttpStatusCode statusCode;

			HttpWebRequest req = (HttpWebRequest)WebRequest.Create(requestURL);
			if (this.proxy != null)
			{
				req.Proxy = proxy;
			}
			using (HttpWebResponse res = (HttpWebResponse)req.GetResponse())
			using (Stream st = res.GetResponseStream())
			{
				xmlDoc.Load(st);
				statusCode = res.StatusCode;
			}

			// [g̗vf擾
			XmlElement xmlRoot = xmlDoc.DocumentElement;

			//ErrorAĂꍇ
			//if (xmlRoot.Name.Equals("Error"))
			if (statusCode != HttpStatusCode.OK)
			{
				// ObZ[W擾
				string errorMessage = GetElementString(xmlRoot.GetElementsByTagName("Message"));
				// O𓊂B
				ThrowException(statusCode, errorMessage);
			}

            // [inagawa] XMLԂĂɎbIΏyvz
            if (string.IsNullOrEmpty(xmlRoot.InnerXml) && string.IsNullOrEmpty(xmlRoot.GetAttribute("totalResultsAvailable")))
            {
                if (++loopCount > 5)
                {
                    // [v񐔂5𒴂O𓊂
                    throw new Exception("Yahoo!K؂XML擾ł܂B");
                }
                System.Diagnostics.Debug.WriteLine("returned XML is empty");
                return DoSearchOriginal(query, results, start);
            }

            // <Result>vftotalResultsAvailablȇl擾
			long totalResultsAvailable = long.Parse(xmlRoot.GetAttribute("totalResultsAvailable"));
			int totalResultsReturned = int.Parse(xmlRoot.GetAttribute("totalResultsReturned"));
			int firstResultPosition = int.Parse(xmlRoot.GetAttribute("firstResultPosition"));

			// ʗvfĂ
			List<YahooJpWebElement> ResultElementList = new List<YahooJpWebElement>();

            //[inagawa]ʂ̐0̌ʃXgԂyvz
            if (totalResultsReturned == 0)
            {
                return new YahooJpWebSearchResult(query, totalResultsAvailable, totalResultsReturned, firstResultPosition, ResultElementList.ToArray());
            }

            XmlNodeList xmlResultList = xmlRoot.GetElementsByTagName("Result");

			int rank = start - 1;
            
            string firstURL = GetElementString(((XmlElement)xmlResultList[0]).GetElementsByTagName("Url"));
			if (alreadyGotURL.ContainsKey(firstURL))
			{
				return new YahooJpWebSearchResult(query, 0, 0, -1, new YahooJpWebElement[0]);
			}
			else
			{
				alreadyGotURL.Add(firstURL, true);
			}

			foreach (XmlElement xmlResult in xmlResultList)
			{
				rank++;
				string title = GetElementString(xmlResult.GetElementsByTagName("Title"));
				string summary = GetElementString(xmlResult.GetElementsByTagName("Summary"));
				string url = GetElementString(xmlResult.GetElementsByTagName("Url"));
				string date = GetElementString(xmlResult.GetElementsByTagName("ModificationDate"));
				string clickurl = GetElementString(xmlResult.GetElementsByTagName("ClickUrl"));
				string mimetype = GetElementString(xmlResult.GetElementsByTagName("MimeType"));
				string cacheUrl = string.Empty;
				string cacheSize = string.Empty;
				XmlNodeList xmlCacheNode = xmlResult.GetElementsByTagName("Cache");
				if (xmlCacheNode != null)
				{
					foreach (XmlElement xmlCacheElement in xmlCacheNode)
					{
						cacheUrl = GetElementString(xmlCacheElement.GetElementsByTagName("Url"));
						cacheSize = GetElementString(xmlCacheElement.GetElementsByTagName("Size"));
					}
				}
				YahooJpWebElement result = new YahooJpWebElement(rank, title, summary, url, clickurl, mimetype, date, cacheUrl, cacheSize);
				ResultElementList.Add(result);
			}

			return new YahooJpWebSearchResult(query, totalResultsAvailable, totalResultsReturned, firstResultPosition, ResultElementList.ToArray());

		}


		/// <summary>
		/// Yahoo!EFus
		/// </summary>
		/// <param name="query">NG[łB̃NG[Yahoo!̑ST|[gA܂^L[[h܂݂܂B</param>
		/// <param name="results">ԋpʂ̐łB</param>
		/// <returns>YahooWebSearchResult^̌</returns>
		private YahooJpWebSearchResult DoSearchOver(string query, int results)
		{
			int i;
			int loop = (results - 1) / 50;
            //List<ISearchResultElement> resultElementList = new List<ISearchResultElement>();
            List<YahooJpWebElement> resultElementList = new List<YahooJpWebElement>();
            long totalResultsAvailable = 0;
			YahooJpWebSearchResult r;

			for (i = 0; i < loop; i++)
			{
                this.loopCount = 0;
                r = DoSearchOriginal(query, 50, ((i * 50) + start));
                if (r.FirstResultPosition == -1) { break; }
                //resultElementList.AddRange(r);
                totalResultsAvailable = r.TotalResultsAvailable;
                resultElementList.AddRange(r.ResultElements);
			}
            this.loopCount = 0;
            r = DoSearchOriginal(query, results - (loop * 50), loop * 50 + start);
            //resultElementList.AddRange(r);
            resultElementList.AddRange(r.ResultElements);
            if (r.FirstResultPosition == -1)
            {
            }
            else
            {
                totalResultsAvailable = r.TotalResultsAvailable;
            }
			return new YahooJpWebSearchResult(query, totalResultsAvailable, resultElementList.Count, 1, resultElementList.ToArray());
		}

		#endregion


		#region Gp\bh

        /// <summary>
        /// XmlNodeList̏߂̃m[h̃eLXg擾
        /// </summary>
        /// <param name="nodeList">XmlNodeList</param>
        /// <returns>XmlNodeList̏߂̃m[hInnerText
        ///          XmlNodeListł΋󕶎Ԃ</returns>
        private string GetElementString(XmlNodeList nodeList)
        {
            if (nodeList.Count == 0)
            {
                return string.Empty;
            }
            else
            {
                return nodeList[0].InnerText;
            }
        }


		/// <summary>
		/// O𓊂
		/// </summary>
		/// <param name="errorCode"></param>
		/// <param name="errorMessage"></param>
		private void ThrowException(HttpStatusCode errorCode, string errorMessage)
		{
			switch (errorCode)
			{
				case HttpStatusCode.BadRequest: // 400
					throw new YahooJpSearchException(YahooJpSearchException.HttpCode.BadRequest, errorMessage);
				case HttpStatusCode.Forbidden: // 403
					throw new YahooJpSearchException(YahooJpSearchException.HttpCode.Forbidden, errorMessage);
				case HttpStatusCode.ServiceUnavailable: // 503
					throw new YahooJpSearchException(YahooJpSearchException.HttpCode.ServiceUnavailable, errorMessage);
				default:
                    throw new Exception("YahooWebSearchőzOHTTPG[܂BiG[R[h: " + (int)errorCode + "j" + errorMessage);
            }
		}

        ///// <summary>
        ///// XmlNodeList̏߂̃m[h̃eLXg擾
        ///// </summary>
        ///// <param name="nodeList">XmlNodeList</param>
        ///// <returns>XmlNodeList̏߂̃m[hInnerText
        /////          XmlNodeListł΋󕶎Ԃ</returns>
        //private string GetElementString(XmlNodeList nodeList)
        //{
        //    if (nodeList.Count == 0)
        //    {
        //        return string.Empty;
        //    }
        //    else
        //    {
        //        return nodeList[0].InnerText;
        //    }
        //}

		/// <summary>
		/// NGXgURL쐬
		/// </summary>
		/// <param name="query">NG[</param>
		/// <param name="type">w茟̎ށ@ftHgall</param>
		/// <param name="results">擾</param>
		/// <param name="start">Jn̐擪ʒu</param>
		/// <param name="format">t@C̎ށ@ftHgany</param>
		/// <param name="adultOk">A_gRečʂ܂߂邩ǂ@ftHgfalse</param>
		/// <param name="similarOk">Recʂ̌ʂƂ邩ǂ@ftHgfalse</param>
		/// <param name="language">languageŏꂽʂɂȂ܂ ftHg͋󕶎</param>
		/// <param name="country">EFuTCgʒu鍑̍R[h@ftHg͋󕶎</param>
		/// <param name="site">hCiႦ www.yahoo.co.jpj𐧌܂B30hC܂Ŏw肷邱Ƃł܂
		/// ftHgnull</param>
		/// <returns>URL</returns>
		private string MakeRequestURL(string query, SearchType type, int results, int start, SearchFormat format, bool adultOk,
			bool similarOk, string language, string country, string[] site)
		{
			string strType = string.Empty;
			string strFormat = string.Empty;
			string strAdult = string.Empty;
			string strSimilar = string.Empty;
			string strLanguage = string.Empty;
			string strCountry = string.Empty;
			string strSite = string.Empty;

			switch (type)
			{
				case SearchType.all:
					break;
				case SearchType.any:
					strType = "&type=any";
					break;
				case SearchType.phrase:
					strType = "&type=phrase";
					break;
			}

			switch (format)
			{
				case SearchFormat.any:
					break;
				case SearchFormat.html:
					strFormat = "&format=html";
					break;
				case SearchFormat.msword:
					strFormat = "&format=msword";
					break;
				case SearchFormat.pdf:
					strFormat = "&format=pdf";
					break;
				case SearchFormat.ppt:
					strFormat = "&format=ppt";
					break;
				case SearchFormat.rss:
					strFormat = "&format=rss";
					break;
				case SearchFormat.txt:
					strFormat = "&format=txt";
					break;
				case SearchFormat.xls:
					strFormat = "&format=xls";
					break;
			}

			if (adultOk == true)
			{
				strAdult = "&adulat_ok=1";
			}

			if (similarOk == true)
			{
				strSimilar = "&similar_ok=1";
			}

			if (String.IsNullOrEmpty(language))
			{
				strLanguage = "&language=ja";
			}
			else
			{
				strLanguage = "&language=" + language;
			}

			if (String.IsNullOrEmpty(country))
			{
			}
			else
			{
				strCountry = "&country=" + country;
			}

			if (site != null)
			{
				if (site.Length > 30)
				{
					throw new ArgumentException("siteɎwłhC30܂łł", "site");
				}
				else
				{
					foreach (string s in site)
					{
						strSite += "&site=" + s;
					}
				}
			}

            string uriString = "http://api.search.yahoo.co.jp/WebSearchService/V1/webSearch?"
            + "appid=" + this.applicationID
                //+ "&query=" + System.Web.HttpUtility.UrlEncode(query, Encoding.UTF8)
            + "&query=" + System.Web.HttpUtility.UrlEncode(query, Encoding.UTF8)
			+ strType
			+ "&results=" + results.ToString()
			+ "&start=" + start.ToString()
			+ strFormat
			+ strAdult
			+ strSimilar
			+ strLanguage
			+ strCountry
			+ strSite;


			//return uriString;

			Uri uri = new Uri(uriString);
			string result = uri.AbsoluteUri;
			//System.Diagnostics.Debug.WriteLine(result);

			return result;
		}

		#endregion


		#region Ŏw肷邽߂̗񋓌^

		/// <summary>
		/// w茟̎
		/// </summary>
		public enum SearchType
		{
			/// <summary>
			/// SNG[܂ތʂԂ܂iftHgjB
			/// </summary>
			all,
			/// <summary>
			/// NG[̂ꂩ܂ތʂԂ܂B
			/// </summary>
			any,
			/// <summary>
			/// NG[𕶏͂ƂĊ܂ތʂԂ܂B
			/// </summary>
			phrase
		}

		/// <summary>
		/// t@C̎ ftHgany
		/// </summary>
		public enum SearchFormat
		{
			/// <summary>
			/// ftHg
			/// </summary>
			any,
			/// <summary>
			/// htmlt@C
			/// </summary>
			html,
			/// <summary>
			/// Wordt@C
			/// </summary>
			msword,
			/// <summary>
			/// PDFt@C
			/// </summary>
			pdf,
			/// <summary>
			/// PowerPointt@C
			/// </summary>
			ppt,
			/// <summary>
			/// RSSt@C
			/// </summary>
			rss,
			/// <summary>
			/// eLXgt@C
			/// </summary>
			txt,
			/// <summary>
			/// Excelt@C
			/// </summary>
			xls
		}

		#endregion


		#region IWebSearch o

        /// <summary>
        /// ahoo!EFus
        /// </summary>
        /// <param name="query">NG[łB̃NG[Yahoo!̑ST|[gA܂^L[[h܂݂܂B</param>
        /// <param name="resultNum">ԋpʂ̐łB</param>
        /// <returns>YahooJapanWebSearchResult^̌</returns>
		IWebSearchResult IWebSearch.DoSearch(string query, int resultNum)
		{
			return this.DoSearch(query, resultNum);
		}

		#endregion


		#region ISearch o

        /// <summary>
        /// ahoo!EFus
        /// </summary>
        /// <param name="query">NG[łB̃NG[Yahoo!̑ST|[gA܂^L[[h܂݂܂B</param>
        /// <param name="resultNum">ԋpʂ̐łB</param>
        /// <returns>YahooJapanWebSearchResult^̌</returns>
		ISearchResult ISearch.DoSearch(string query, int resultNum)
		{
			return this.DoSearch(query, resultNum);
		}

		#endregion

	}
}
