﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;


namespace SlothLib.Web.Search
{
    /// <summary>
    /// Yahoo! 動画検索の検索結果を格納するクラス
    /// </summary>
	[Serializable]
	public class YahooJpVideoSearchResult : IVideoSearchResult
    {

		#region privateフィールド

        private YahooJpVideoElement[] resultElements;
		private string query;

		private long totalResultsAvailable;
		private int totalResultsReturned;
        private int firstResultPosition;
        //private List<ISearchResultElement> elementList;
        

		#endregion

        #region コンストラクタ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="query">検索クエリ</param>
        /// <param name="totalResultsAvailable">データ内のマッチしたクエリ数です。</param>
		/// <param name="totalResultsReturned">返却され、かつマッチしたクエリの数です。もし有効な結果の合計が少ない場合、要求した結果の数より少ない場合があります。</param>
		/// <param name="firstResultPosition">全検索結果の最初のポジションです。</param>
		/// <param name="resultElements"></param>
		public YahooJpVideoSearchResult(string query, long totalResultsAvailable, int totalResultsReturned, int firstResultPosition, YahooJpVideoElement[] resultElements)
        {
			this.query = query;

			this.totalResultsAvailable = totalResultsAvailable;
			this.totalResultsReturned = totalResultsReturned;
			this.firstResultPosition = firstResultPosition;
            //this.elementList = new List<ISearchResultElement>(resultElements);
            this.resultElements = resultElements;
        }

        ///// <summary>
        ///// コンストラクタ
        ///// </summary>
        ///// <param name="totalResultsAvailable">データ内のマッチしたクエリー数です。</param>
        ///// <param name="totalResultsReturned">返却され、かつマッチしたクエリーの数です。もし有効な結果の合計が少ない場合、要求した結果の数より少ない場合があります。</param>
        ///// <param name="firstResultPosition">全検索結果の最初のポジションです。</param>
        ///// <param name="resultElements"></param>
        //public YahooJpVideoSearchResult(string query, long totalResultsAvailable, int totalResultsReturned, int firstResultPosition, ISearchResultElement[] resultElements)
        //{
        //    this.query = query;

        //    this.totalResultsAvailable = totalResultsAvailable;
        //    this.totalResultsReturned = totalResultsReturned;
        //    this.firstResultPosition = firstResultPosition;
        //    this.elementList = new List<ISearchResultElement>(resultElements);
        //}

        #endregion

        #region プロパティ

        /// <summary>
        /// 検索結果要素の配列
        /// </summary>
        public YahooJpVideoElement[] ResultElements
        {
            get { return this.resultElements; }
        }

		/// <summary>
		/// 検索に使われたクエリ
		/// </summary>
		public string Query
		{
			get
			{
				return this.query;
			}
		}

		/// <summary>
		/// 検索総件数
		/// </summary>
		public long TotalResultsAvailable
		{
			get
			{
				return this.totalResultsAvailable;
			}
		}

		/// <summary>
		/// この検索結果に含まれる検索結果数
		/// </summary>
		public int TotalResultsReturned
		{
			get
			{
				return this.totalResultsReturned;
			}
		}

		/// <summary>
		/// 全検索結果の最初のポジション
		/// </summary>
		public int FirstResultPosition
		{
			get
			{
				return this.firstResultPosition;
			}
		}

        //public int Count
        //{
        //    get
        //    {
        //        return this.elementList.Count;
        //    }
        //}

        #endregion

        #region ISerializable メンバ

        /// <summary>
        /// シリアライズ化するときに呼び出される関数
        /// </summary>
        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
        void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
        {
            info.AddValue("totalResultsAvailable", this.totalResultsAvailable);
            info.AddValue("totalResultsReturned", this.totalResultsReturned);
            info.AddValue("firstResultPosition", this.firstResultPosition);
            //info.AddValue("elementList",this.elementList);
            info.AddValue("resultElements", this.resultElements);
        }

        /// <summary>
        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
        /// </summary>
        /// <param name="info">シリアル化に必要なすべてのデータ</param>
        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
        protected YahooJpVideoSearchResult(SerializationInfo info, StreamingContext context)
        {
            this.totalResultsReturned = info.GetInt32("totalResultsReturned");
            this.totalResultsAvailable = info.GetInt64("totalResultsAvailable");
            this.firstResultPosition = info.GetInt32("firstResultPosition");
            //this.elementList = (List<ISearchResultElement>)info.GetValue("elementList", typeof(List<ISearchResultElement>));
            this.resultElements = (YahooJpVideoElement[])info.GetValue("resultElements", typeof(YahooJpVideoElement[]));
        }
        #endregion

        #region IVideoSearchResult メンバ

        IVideoElement[] IVideoSearchResult.ResultElements
        {
            get { return this.ResultElements; }
        }

        //IVideoElement IVideoSearchResult.this[int index]
        //{
        //    get
        //    {
        //        return (IVideoElement)this.elementList[index];
        //    }
        //}

        #endregion

        #region ISearchResult メンバ

        ISearchResultElement[] ISearchResult.ResultElements
        {
            get { return this.ResultElements; }
        }

        string ISearchResult.Query
        {
            get
            {
                return this.query;
            }
        }

        long ISearchResult.TotalNumber
        {
            get
            {
                return this.totalResultsAvailable;
            }
        }

        #endregion
    }
}
