﻿using System;
using System.Collections.Generic;
using System.Text;

using System.Xml;
using System.Net;
using System.IO;
using System.Web;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// 教えて！Goo検索を行う
    /// </summary>
    /// <remarks>
    /// 
    /// <newpara>[2007-06-12][inagawa]作成</newpara>
    /// </remarks>
    public class OshieteGooSearch : ISearch
    {
        #region コンストラクタ
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public OshieteGooSearch() { }
        #endregion

        #region private フィールド

        // proxy
        private WebProxy proxy;

        #endregion

        #region Proxy設定

        /// <summary>
        /// プロクシを設定する。
        /// </summary>
        /// <param name="proxyAddress"></param>
        public void SetProxy(string proxyAddress)
        {
            if (proxyAddress == null)
            {
                this.proxy = null;
            }
            else
            {
                this.proxy = new WebProxy(proxyAddress);
            }
        }

        #endregion

        #region DoSearch

        /// <summary>
        /// 教えて！Goo検索を行う
        /// </summary>
        /// <param name="query">クエリ</param>
        /// <param name="maxNumber">最大結果数</param>
        /// <returns></returns>
        public OshieteGooSearchResult DoSearch(string query, int maxNumber)
        {
            return DoOshieteSearch(query, maxNumber);
        }

        #endregion

        #region 実働メソッド

        private OshieteGooSearchResult DoOshieteSearch(string query, int maxNumber)
        {
            List<OshieteGooElement> elements = new List<OshieteGooElement>();
            long searchTotalResults = 0;
            int rank = 0;

            for (int page = 1; ; page++)
            {
                string requestURL = MakeRequestURL(query, maxNumber, page);

                XmlDocument xmlDoc = new XmlDocument();
                HttpWebRequest req = (HttpWebRequest)WebRequest.Create(requestURL);
                if (this.proxy != null)
                {
                    req.Proxy = proxy;
                }

                using (HttpWebResponse res = (HttpWebResponse)req.GetResponse())
                using (Stream st = res.GetResponseStream())
                {
                    xmlDoc.Load(st);
                }
                // ルートの要素を取得
                XmlElement xmlRoot = xmlDoc.DocumentElement;
                searchTotalResults = long.Parse(GetElementString(xmlRoot.GetElementsByTagName("oshietegoo:searchTotalResults")));

                XmlNodeList xmlItemList = xmlRoot.GetElementsByTagName("item");
                foreach (XmlElement xmlItem in xmlItemList)
                {
                    rank++;
                    string title = GetElementString(xmlItem.GetElementsByTagName("title"));
                    string url = GetElementString(xmlItem.GetElementsByTagName("link"));
                    string description = GetElementString(xmlItem.GetElementsByTagName("description"));
                    string category = GetElementString(xmlItem.GetElementsByTagName("dc:subject"));
                    string pubData = GetElementString(xmlItem.GetElementsByTagName("dc:date"));
                    string creater = GetElementString(xmlItem.GetElementsByTagName("dc:creator"));

                    OshieteGooElement element = new OshieteGooElement(url, title, description, pubData, category, creater, rank);
                    elements.Add(element);

                    if (elements.Count >= maxNumber || elements.Count >= searchTotalResults)
                    {
                        int resultNum = elements.Count;
                        return new OshieteGooSearchResult(query, searchTotalResults, elements.ToArray());
                    }
                }
            }//forループの終わり
        }

        #endregion

        #region 雑用メソッド

        private string MakeRequestURL(string query, int maxNumber, int page)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append("http://oshiete.goo.ne.jp/search/search.php?status=select&mt_opt=a&rss=1&MT=");
            builder.Append(HttpUtility.UrlEncode(query, Encoding.GetEncoding("euc-jp")));
            //builder.Append(query);
            builder.Append("&dc=");
            builder.Append(Math.Min(maxNumber, 50));
            builder.Append("&pg=");
            builder.Append(page);

            return builder.ToString();

            //Uri uri = new Uri(builder.ToString());
            //return uri.AbsoluteUri;
        }

        /// <summary>
        /// XmlNodeListの初めのノードのテキストを取得する
        /// </summary>
        /// <param name="nodeList">XmlNodeList</param>
        /// <returns>XmlNodeListの初めのノードのInnerText
        ///          XmlNodeListが空であれば空文字列を返す</returns>
        private string GetElementString(XmlNodeList nodeList)
        {
            if (nodeList.Count == 0)
            {
                return string.Empty;
            }
            else
            {
                return nodeList[0].InnerText;
            }
        }

        #endregion


        #region ISearch メンバ

        ISearchResult ISearch.DoSearch(string query, int resultNum)
        {
            return this.DoSearch(query,resultNum);
        }

        #endregion
    }
}
