﻿using System;
using System.Collections.Generic;
using System.Text;

using System.Runtime.Serialization;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// 教えて！Goo検索の要素
    /// </summary>
    /// <remarks>
    /// 
    /// <newpara>[2007-06-12][inagawa]作成</newpara>
    /// </remarks>
    public class OshieteGooElement : ISearchResultElement
    {
        #region privateフィールド

        private string url;
        private string title;
        private string description;
        private string date;
        private string category;
        private string author;
        private int rank; //one origin

        #endregion

        #region プロパティ

        /// <summary>
        /// 質問ページのURL
        /// </summary>
        public string URL
        {
            get { return url; }
        }
        /// <summary>
        /// タイトル
        /// </summary>
        public string Title
        {
            get { return title; }
        }
        /// <summary>
        /// 質問文の一部
        /// </summary>
        public string Description
        {
            get { return description; }
        }
        /// <summary>
        /// 投稿日時
        /// </summary>
        public DateTime Date
        {
            get
            {
                //更新日時がない場合、何もしない
                if (String.IsNullOrEmpty(this.date))
                {
                    return new DateTime();
                }

                else
                {
                    //更新日時の文字列をDateTime型に変換
                    try
                    {
                        //2005-09-25T17:17:00+09:00
                        DateTime modDate = DateTime.ParseExact(this.date, "yyyy-MM-dd'T'HH:mm:sszzz",
                            System.Globalization.DateTimeFormatInfo.InvariantInfo, System.Globalization.DateTimeStyles.None);
                        return modDate;
                    }
                    catch
                    {
                        System.Diagnostics.Debug.WriteLine(this.date);
                    }
                }
                return new DateTime();
            }
        }
        /// <summary>
        /// カテゴリ
        /// </summary>
        public string Category
        {
            get { return category; }
        }
        /// <summary>
        /// 質問者
        /// </summary>
        public string Author
        {
            get { return author; }
        }
        /// <summary>
        /// ランク
        /// </summary>
        public int Rank
        {
            get { return rank; }
        }

        #endregion

        #region コンストラクタ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="url">質問ページのURL</param>
        /// <param name="title">タイトル</param>
        /// <param name="description">質問文の一部</param>
        /// <param name="date">投稿日時</param>
        /// <param name="category">カテゴリ</param>
        /// <param name="author">質問者</param>
        /// <param name="rank">質問者</param>
        public OshieteGooElement(string url, string title, string description, string date, string category, string author, int rank)
        {
            this.title = title;
            this.url = url;
            this.description = description;
            this.category = category;
            this.date = date;
            this.author = author;
            this.rank = rank;
        }

        #endregion


        #region ISearchResultElement メンバ

        /// <summary>
        /// 質問ページのURL
        /// </summary>
        string ISearchResultElement.URL
        {
            get { return this.URL; }
        }

        /// <summary>
        /// タイトル
        /// </summary>
        string ISearchResultElement.Title
        {
            get { return this.Title; }
        }

        /// <summary>
        /// 質問文の一部
        /// </summary>
        string ISearchResultElement.Description
        {
            get { return this.Description; }
        }

        #endregion

        #region ISerializable メンバ

        void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
        {
            info.AddValue("url", this.url);
            info.AddValue("title", this.title);
            info.AddValue("description", this.description);
            info.AddValue("date", this.date);
            info.AddValue("category", this.category);
            info.AddValue("author", this.author);
            info.AddValue("rank", this.rank);
        }

        /// <summary>
        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
        /// </summary>
        /// <param name="info"></param>
        /// <param name="context"></param>
        protected OshieteGooElement(SerializationInfo info, StreamingContext context)
        {
            this.url = info.GetString("url");
            this.title = info.GetString("title");
            this.description = info.GetString("description");
            this.date = info.GetString("date");
            this.category = info.GetString("category");
            this.author = info.GetString("author");
            this.rank = info.GetInt32("rank");
        }

        #endregion


    }
}
