﻿using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.Web.Search;
using System.Runtime.Serialization;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// Flickr検索結果の要素を格納する
    /// </summary>
    [Serializable]
    public class FlickrElement : IImageElement
    {

        #region コンストラクタ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="id">画像のID</param>
        /// <param name="owner">所有者のID</param>
        /// <param name="secret">Secret</param>
        /// <param name="server">Server</param>
        /// <param name="farm">Farm</param>
        /// <param name="title">画像のタイトル</param>
        /// <param name="isPublic">画像が公開されているかどうか</param>
        /// <param name="isFriend">画像の所有者の友達であるかどうか</param>
        /// <param name="isFamily">画像の所有者の家族であるかどうか</param>
        /// <param name="rank">検索結果の順位</param>
        public FlickrElement(string id, string owner, string secret, string server, string farm, string title,
            bool isPublic, bool isFriend, bool isFamily, int rank)
        {
            this.id = id;
            this.owner = owner; 
            this.secret = secret; 
            this.server = server;
            this.farm = farm; 
            this.title = title;
            this.isPublic = isPublic; 
            this.isFriend = isFriend; 
            this.isFamily = isFamily;
            this.rank = rank;

        }

        #endregion

        #region privateフィールド

        private string id;
        private string owner;
        private string secret;
        private string server;
        private string farm;
        private string title;
        private int rank;
        private bool isPublic;
        private bool isFriend;
        private bool isFamily;

        #endregion

        #region プロパティ


        /// <summary>
        /// 画像のID
        /// </summary>
        public string ID
        {
            get
            {
                return this.id;
            }
        }

        /// <summary>
        /// タイトル
        /// </summary>
        public string Title
        {
            get
            {
                return this.title;
            }
        }

        /// <summary>
        /// 画像の所有者
        /// </summary>
        public string Owner
        {
            get
            {
                return this.owner;
            }
        }

        /// <summary>
        /// 画像が公開されているかどうか
        /// </summary>
        public bool IsPublic
        {
            get
            {
                return this.isPublic;
            }
        }

        /// <summary>
        /// 画像の所有者の友達であるかどうか
        /// </summary>
        public bool IsFriend
        {
            get
            {
                return this.isFriend;
            }
        }

        /// <summary>
        /// 画像の所有者の家族であるかどうか
        /// </summary>
        public bool IsFamily
        {
            get
            {
                return this.isFamily;
            }
        }


        /// <summary>
        /// URL
        /// </summary>
        public string URL
        {
            get
            {
                string url = @"http://farm" + farm + @".static.flickr.com/" + server + @"/" + id + @"_" + secret + @".jpg";

                return url;
            }
        }

        #endregion

        #region ToString
        /// <summary>
        /// ToStringのオーバーライド
        /// </summary>
        /// <returns>Flickr検索結果要素の内容</returns>
        public override string ToString()
        {
            return "Title: " + title + "\r\n"
                + "URL: " + @"http://farm" + farm + @".static.flickr.com/" + server + @"/" + id + @"_" + secret + @".jpg";
        }

        #endregion

        #region ISearchResultElement メンバ

        /// <summary>
        /// ページのURL
        /// </summary>
        string ISearchResultElement.URL
        {
            get {
                string url = @"http://farm" + farm + @".static.flickr.com/" + server + @"/" + id + @"_" + secret + @".jpg";
                return url; 
            }
        }

        /// <summary>
        /// ページのタイトル
        /// </summary>
        string ISearchResultElement.Title
        {
            get { return this.Title; }
        }

        /// <summary>
        /// ページの要約(未実装)
        /// 現在はTitleと同じ値を出力
        /// </summary>
        string ISearchResultElement.Description
        {
            get { return this.title; }
        }

        #endregion

        #region ISerializable メンバ

        /// <summary>
        /// シリアライズ化するときに呼び出される関数
        /// </summary>
        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
            info.AddValue("id", this.id);
            info.AddValue("owner", this.owner);
            info.AddValue("secret", this.secret);
            info.AddValue("server", this.server);
            info.AddValue("farm", this.farm);
            info.AddValue("title", this.title);
            info.AddValue("isPublic", this.isPublic);
            info.AddValue("isFriend", this.isFriend);
            info.AddValue("isFamily", this.isFamily);
		}

        /// <summary>
        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
        /// </summary>
        /// <param name="info">シリアル化に必要なすべてのデータ</param>
        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
		protected FlickrElement(SerializationInfo info, StreamingContext context)
		{
            this.id = info.GetString("id");
            this.owner = info.GetString("owner");
            this.secret = info.GetString("secret");
            this.server = info.GetString("server");
            this.farm = info.GetString("farm");
            this.title = info.GetString("title");
            this.isPublic = info.GetBoolean("isPublic");
            this.isFriend = info.GetBoolean("isFriend");
            this.isFamily = info.GetBoolean("isFamily");
		}


		#endregion


        #region ISearchResultElement メンバ


        int ISearchResultElement.Rank
        {
            get { return this.rank; }
        }

        #endregion
    }
}
