using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    public partial class FormGoogleSOAP : Form
    {
        public FormGoogleSOAP()
        {
            InitializeComponent();
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            SlothLib.Web.Search.GoogleSOAPSearchAPI search;
            string lang = "";
            string apiKey = tbKey.Text;

            if (cbEnumLang.Text != "")
            {
                if (cbEnumLang.Text == "p")
                {
                    search = new SlothLib.Web.Search.GoogleSOAPSearchAPI(apiKey,SlothLib.Web.Search.GoogleSOAPSearchAPI.Language.English);
                    lang = "(English)";
                }
                else if(cbEnumLang.Text == "{")
                {
                    search = new SlothLib.Web.Search.GoogleSOAPSearchAPI(apiKey,SlothLib.Web.Search.GoogleSOAPSearchAPI.Language.Japanese);
                    lang = "(Japanese)";
                }
                else
                {
                    search = new SlothLib.Web.Search.GoogleSOAPSearchAPI(apiKey, SlothLib.Web.Search.GoogleSOAPSearchAPI.Language.All);
                    lang = "(ALL)";
                }
            }
            else if(cbStringLang.Text != "")
            {
                search = new SlothLib.Web.Search.GoogleSOAPSearchAPI(apiKey, cbStringLang.Text);
            }
            else
            {
                search = new SlothLib.Web.Search.GoogleSOAPSearchAPI(apiKey);
                lang = "(Japanese)";
            }

            GoogleSOAPSearchAPIResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.ResultElements.Length.ToString() +"/"+result.TotalNumber.ToString() + "";
            
            lblQuery.Text = result.Query + lang;

            lvResult.Items.Clear();
            foreach (GoogleSOAPElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.Description);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.Rank.ToString());
                
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }
        }
    }
}