using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    public partial class FormGooBlog : Form
    {
        public FormGooBlog()
        {
            InitializeComponent();
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            GooBlogSearch search;
            search = new GooBlogSearch();

            if (cbSortType.Text != "")
            {
                if (cbSortType.Text == "Date")
                {
                    search.SortBy = GooBlogSearch.SortType.Date;
                }
                else
                {
                    search.SortBy = GooBlogSearch.SortType.Score;
                }
                
            }
            GooBlogSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.SearchTotalResults.ToString() + "";
            lblResultNum.Text = result.ResultElements.Length + "";

            lblQuery.Text = result.Query;

            lvResult.Items.Clear();
            foreach (GooBlogElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.Description);
                item.SubItems.Add(element.Link);
                item.SubItems.Add(element.Source);
                item.SubItems.Add(element.SourceURL);
                item.SubItems.Add(element.Date.ToString());
                
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }
        }
    }
}