using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.NLP;

namespace SlothLibTests.NLP
{
    public partial class FormNLPMeCab : Form
    {
        public FormNLPMeCab()
        {
            InitializeComponent();
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            MeCab meCab = new MeCab();
            MeCabResult result = meCab.DoAnalyze(rtbInput.Text);
            lvResult.Items.Clear();
            foreach (MeCabMorpheme morpheme in result.Morphemes)
            {
                ListViewItem item = new ListViewItem(morpheme.Raw);
                item.SubItems.Add(morpheme.Original);
                item.SubItems.Add(morpheme.POS);
                item.SubItems.Add(morpheme.ConjugationPattern);
                item.SubItems.Add(morpheme.ConjugationForm);
                item.SubItems.Add(morpheme.Reading);
                item.SubItems.Add(morpheme.Pronunciation);
                lvResult.Items.Add(item);
            }
        }
    }
}