using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using SlothLib.NLP;

namespace SlothLibTests.NLP
{
    public partial class FormNLPFilter : Form
    {
        private IMorphologicalAnalyzer analyzer;
        private MorphemeFilterList filterList;

        public FormNLPFilter()
        {
            InitializeComponent();
            cbAnalyzer.SelectedIndex = 0; //ftHg͌`ԑf͂Ȃ
            filterList = new MorphemeFilterList(); //tB^Xg
        }

        private void btnSbmit_Click(object sender, EventArgs e)
        {
            try
            {
                StringBuilder builder = new StringBuilder();
                //`ԑf͊gȂꍇ
                if (this.analyzer == null)
                {
                    //̓eLXgsƂɐ؂蕪
                    string[] inputStrings = txtInput.Text.Split(new string[] { "\r\n", "\r", "\n" },StringSplitOptions.RemoveEmptyEntries);
                    //StringFilterKp
                    string[] resultStrings = this.filterList.DoStringFilter(inputStrings);
                    foreach (string s in resultStrings)
                    {
                        builder.AppendLine(s);
                    }
                }
                //`ԑf͊gꍇ
                else
                {
                    //`ԑf
                    IMorphologicalAnalyzerResult result = analyzer.DoAnalyze(txtInput.Text);
                    txtOutput.Text = "";

                    //`ԑf𕶎ɕϊtB^o^Ăꍇ
                    if (this.filterList.HasMorphemeToStringFilter)
                    {
                        string[] resultStrings = this.filterList.DoMorphemeToStringFilter(result.Morphemes);
                        foreach (string s in resultStrings)
                        {
                            builder.AppendLine(s);
                        }
                    }
                    //`ԑf𕶎ɕϊtB^o^ĂȂꍇ
                    else
                    {
                        IMorpheme[] resultMorphemes = this.filterList.DoMorphemeFilter(result.Morphemes);
                        foreach (IMorpheme morpheme in resultMorphemes)
                        {
                            builder.AppendLine(morpheme.ToString());
                        }
                    }
                }
                //\
                txtOutput.Text = builder.ToString();

            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        //`ԑf͊ύX
        private void cbAnalyzer_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch (cbAnalyzer.Text)
            {
                case "ChaSen":
                    analyzer = new ChaSen();
                    break;
                case "MeCab":
                    analyzer = new MeCab();
                    break;
                case "MeCabServer":
                    analyzer = new MeCabServer();
                    break;
                case "SSTagger":
                    try
                    {
                        analyzer = new SSTaggerServer(tbSSTaggerPath.Text);
                    }
                    catch
                    {
                        MessageBox.Show("SSTagger̃pX܂B");
                    }
                    break;
                case "TreeTagger":
                    try
                    {
                        analyzer = new TreeTagger(tbTreeTaggerPath.Text);
                    }
                    catch
                    {
                        MessageBox.Show("TreeTagger̃pX܂B");
                    }
                    break;
                default:
                    analyzer = null;
                    break;
            }
        }

        //tB^XgɃtB^ǉ
        private void btnAdd_Click(object sender, EventArgs e)
        {
            switch (cbFilter.Text)
            {
                case "AlphaDigitToNarrowFilter":
                    filterList.Add(new AlphaDigitToNarrowFilter());
                    break;
                case "AlphaDigitToNarrowHalfKanaToWideFilter":
                    filterList.Add(new AlphaDigitToNarrowHalfKanaToWideFilter());
                    break;
                case "HalfKanaToWideFilter":
                    filterList.Add(new HalfKanaToWideFilter());
                    break;
                case "ToLowerFilter":
                    filterList.Add(new ToLowerFilter());
                    break;
                case "ToNarrowFilter":
                    filterList.Add(new ToNarrowFilter());
                    break;
                case "ToTitleCaseFilter":
                    filterList.Add(new ToTitleCaseFilter());
                    break;
                case "ToUpperFilter":
                    filterList.Add(new ToUpperFilter());
                    break;
                case "ToWideFilter":
                    filterList.Add(new ToWideFilter());
                    break;
                case "RemainOriginalFilter":
                    filterList.Add(new RemainOriginalFilter());
                    break;
                case "RemainRawFilter":
                    filterList.Add(new RemainRawFilter());
                    break;
                case "RemainPosFilter":
                    filterList.Add(new RemainPosFilter());
                    break;
                case "PosFilter":
                    filterList.Add(new PosFilter("||N",".*㖼"));
                    break;
                case "RegexFilter":
                    filterList.Add(new RegexFilter(null,new Regex("^[a-z]+$")));
                    break;
                case "StopWordFilter":
                    StopWordFilter stopWordFilter = new StopWordFilter();
                    stopWordFilter.LoadSymbolList(@"..\..\..\..\data\StopWord\symbol");
                    stopWordFilter.LoadWordList(@"..\..\..\..\data\StopWord\word");
                    filterList.Add(stopWordFilter);
                    break;
                case "SymbolToNarrowFilter":
                    filterList.Add(new SymbolToNarrowFilter());
                    break;
                default:
                    break;
            }
            //Xgr[ɒǉ
            if (!string.IsNullOrEmpty(cbFilter.Text))
            {
                ListViewItem lvitem = new ListViewItem(cbFilter.Text);
                lvFilter.Items.Add(lvitem);
            }
        }

        //tB^XgNA
        private void btnClear_Click(object sender, EventArgs e)
        {
            this.filterList = new MorphemeFilterList();
            lvFilter.Items.Clear();
        }
    }
}