using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.LinearAlgebra.Matrix;

namespace SlothLib.LinearAlgebra.R.Matrix
{
    public class SVDCalculator
    {
        public SVDCalculator()
        { }

        public SVDResult DoCalculate(IMatrix matrix)
        {
            ROperator.Set("m", matrix.GetPlainMatrix());
            ROperator.Run("r<-svd(m)");			
            
            double[] d = null;
			double[,] u = null;
			double[,] v = null;

            d = ROperator.Run("r$d") as double[]; 
            u = ROperator.Run("r$u") as double[,];
            v = ROperator.Run("r$v") as double[,];

            ROperator.Close();

            return new SVDResult(u, d, v);
        }
    }
}
