using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// Kw^NX^OC^[tF[X
	/// </summary>
	public interface IHierarchicalClustering<T>
	{

		/// <summary>
		/// NX^1ɂȂ܂ŊKwINX^Os
		/// </summary>
		/// <param name="vectors"></param>
		/// <returns></returns>
		HierarchicalClusteringResult<T> DoClustering(IVector<T>[] vectors);

		/// <summary>
		/// NX^̐wlɂȂ܂ŊKwINX^Os
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="thresholdClusterCount"></param>
		/// <returns></returns>
		HierarchicalClusteringResult<T> DoClustering(IVector<T>[] vectors, int thresholdClusterCount);

		/// <summary>
		/// ݂̃NX^̋wl艓Ȃ܂ŊKwINX^Os
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="thresholdDistanceOrSimilarity"></param>
		/// <returns></returns>
		HierarchicalClusteringResult<T> DoClustering(IVector<T>[] vectors, double thresholdDistanceOrSimilarity);

		/// <summary>
		/// NX^̐wlɂȂ邩Ã݂NX^̋wl艓Ȃ܂ŊKwINX^Os
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="thresholdClusterCount"></param>
		/// <param name="thresholdDistanceOrSimilarity"></param>
		/// <returns></returns>
		HierarchicalClusteringResult<T> DoClustering(IVector<T>[] vectors, int thresholdClusterCount, double thresholdDistanceOrSimilarity);

	}
}
