using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// Qϖ@
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class GroupAverageClustering<T> : HierarchicalClustering<T>
	{

		/// <summary>
		/// e[u쐬ɗp
		/// </summary>
		/// <param name="distanceCalculator"></param>
		public GroupAverageClustering(IDistanceCalculator<T> distanceCalculator)
			: base(distanceCalculator)
		{
		}

		/// <summary>
		/// ގxe[u쐬ɗp
		/// </summary>
		/// <param name="similarityCalculator"></param>
		public GroupAverageClustering(ISimilarityCalculator<T> similarityCalculator)
			: base(similarityCalculator)
		{
		}

		/// <summary>
		/// NX^OۂɍsNXԂ
		/// </summary>
		/// <param name="vectors"></param>
		/// <returns></returns>
		protected override IHierarchicalClusteringProcess<T> GetProcess(IVector<T>[] vectors)
		{
			return new GroupAverageClusteringProcess<T>(vectors, this.calculator, this.dType);
		}

	}
}
