using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// ŒZ@
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class CentroidClusteringProcess<T> : HierarchicalClusteringProcess<T>
	{

		/// <summary>
		/// ̃NX^ɑĂACe̐i[Ă
		/// </summary>
		protected int[] itemCountInCluster;

		/// <summary>
		/// ̃NX^̑\xNgi[Ă
		/// </summary>
		protected IVector<T>[] centroidVectors;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="calculator"></param>
		/// <param name="dType"></param>
		public CentroidClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType)
			: base(vectors, calculator, dType)
		{
			itemCountInCluster = new int[this.itemCount];
			centroidVectors = new IVector<T>[this.itemCount];
			for (int i = 0; i < this.itemCount; i++)
			{
				// ͂߂͑S1B
				itemCountInCluster[i] = 1;
				// ͂߂͑Sg̃xNgîߌvZς݂̒lŕێBj
				centroidVectors[i] = new BasicVector<T>(vectors[i]);
			}
		}

		/// <summary>
		/// fhÕm[h擾
		/// </summary>
		/// <param name="cid1"></param>
		/// <param name="cid2"></param>
		/// <param name="minDistance"></param>
		/// <returns></returns>
		protected override IDendrogramNode<T> GetDendrogramNode(int cid1, int cid2, double minDistance)
		{
			return new CentroidDendrogramNode<T>(cid1, cid2, minDistance, centroidVectors[cid1]);
		}

		/// <summary>
		/// NX^
		/// </summary>
		/// <param name="cid1"></param>
		/// <param name="cid2"></param>
		protected override void Union(int cid1, int cid2)
		{
			// NX^ԍ̍XV
			clusterID[cid2] = cid1;

			// ꂽNX^̑\xNg̍XV
			IVector<T> v1 = new MultiplyVector<T>(itemCountInCluster[cid1], centroidVectors[cid1]);
			IVector<T> v2 = new MultiplyVector<T>(itemCountInCluster[cid2], centroidVectors[cid2]);
			int c = itemCountInCluster[cid1] + itemCountInCluster[cid2];
			IVector<T> v = new MultiplyVector<T>(1.0 / c, new AddVector<T>(v1, v2));
			centroidVectors[cid1] = v;
			// ACe̍XV
			itemCountInCluster[cid1] = c;

			// e[u̍XV
			for (int i = 0; i < this.itemCount; i++)
			{
				// NX^̑\ł͂ȂAe[ȗΊp͍XVEQƂ̑Ώۂł͂ȂB
				if (clusterID[i] != i || i == cid1 || i == cid2)
				{
					continue;
				}

				SetDistance(cid1, i, this.calculator.DoCalculate(centroidVectors[i], v) * this.ds);
			}
		}

	}
}
