﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// 累乗
	/// Value = Value ^ exponent
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class PowerVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vector"></param>
		/// <param name="exponent"></param>
		public PowerVector(IVector<T> vector, double exponent)
		{
			foreach (T key in vector.Keys)
			{
				this[key] = Math.Pow(vector[key], exponent);
			}
		}
	}
}
