﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// ベクトルの逆数を取ったベクトル
	/// this[i] = 1 / vector[i]
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class InverseVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public InverseVector(IVector<T> vector)
		{
			foreach (T key in vector.Keys)
			{
                if (vector[key] != 0.0)
                {
                    this[key] = 1 / vector[key];
                }
                else
                {
                    this[key] = 0.0;
                }
			}
		}
	}
}
