﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// ある要素に対して、元のベクトル群のうち、0ではないものの数を数える
	/// Value = Count( Values.contains(key) )
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class DocumentFrequencyVector<T> : BasicVector<T>, IDocumentFrequencyVector<T>
	{
		//コンストラクタに与えられたベクトルの数
		private int vectorCount;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vectors"></param>
		public DocumentFrequencyVector(IEnumerable<IVector<T>> vectors)
		{
			Calculate(vectors);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vectors"></param>
		public DocumentFrequencyVector(params IVector<T>[] vectors)
		{
			Calculate(vectors);
		}

		/// <summary>
		/// ベクトル群のdocument frequency値を計算し、thisに格納する
		/// すなわち、ある次元keyに対し、そのkeyを持つベクトル数をそのkeyに格納する
		/// </summary>
		private void Calculate(IEnumerable<IVector<T>> vectors)
		{
			int i = 0;

			foreach (IVector<T> v in vectors)
			{
				i++;
				foreach (T key in v.Keys)
				{
					if (v[key] != 0)
					{
						if (this.ContainsKey(key))
						{
							this[key]++;
						}
						else
						{
							this[key] = 1;
						}
					}
				}
			}

			vectorCount = i;
		}

		#region IDocumentFrequency<T> メンバ

		/// <summary>
		/// いくつのベクトルからこのベクトルが作成されたか
		/// </summary>
		public int VectorCount
		{
			get { return this.vectorCount; }
		}

		#endregion
	}
}
